/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.tls;

import org.bouncycastle.crypto.AsymmetricBlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.CryptoException;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.Signer;
import org.bouncycastle.crypto.encodings.PKCS1Encoding;
import org.bouncycastle.crypto.engines.RSABlindedEngine;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.crypto.params.RSAKeyParameters;
import org.bouncycastle.crypto.signers.GenericSigner;
import org.bouncycastle.crypto.signers.RSADigestSigner;
import org.bouncycastle.crypto.tls.AbstractTlsSigner;
import org.bouncycastle.crypto.tls.CombinedHash;
import org.bouncycastle.crypto.tls.ProtocolVersion;
import org.bouncycastle.util.Arrays;

public class TlsRSASigner
extends AbstractTlsSigner {
    @Override
    public byte[] generateRawSignature(AsymmetricKeyParameter asymmetricKeyParameter, byte[] byArray) throws CryptoException {
        AsymmetricBlockCipher asymmetricBlockCipher = this.createRSAImpl();
        asymmetricBlockCipher.init(true, new ParametersWithRandom(asymmetricKeyParameter, this.context.getSecureRandom()));
        return asymmetricBlockCipher.processBlock(byArray, 0, byArray.length);
    }

    @Override
    public boolean verifyRawSignature(byte[] byArray, AsymmetricKeyParameter asymmetricKeyParameter, byte[] byArray2) throws CryptoException {
        AsymmetricBlockCipher asymmetricBlockCipher = this.createRSAImpl();
        asymmetricBlockCipher.init(false, asymmetricKeyParameter);
        byte[] byArray3 = asymmetricBlockCipher.processBlock(byArray, 0, byArray.length);
        return Arrays.constantTimeAreEqual(byArray3, byArray2);
    }

    @Override
    public Signer createSigner(AsymmetricKeyParameter asymmetricKeyParameter) {
        return this.makeSigner(new CombinedHash(), true, new ParametersWithRandom(asymmetricKeyParameter, this.context.getSecureRandom()));
    }

    @Override
    public Signer createVerifyer(AsymmetricKeyParameter asymmetricKeyParameter) {
        return this.makeSigner(new CombinedHash(), false, asymmetricKeyParameter);
    }

    @Override
    public boolean isValidPublicKey(AsymmetricKeyParameter asymmetricKeyParameter) {
        return asymmetricKeyParameter instanceof RSAKeyParameters && !asymmetricKeyParameter.isPrivate();
    }

    protected Signer makeSigner(Digest digest, boolean bl, CipherParameters cipherParameters) {
        Signer signer = ProtocolVersion.TLSv12.isEqualOrEarlierVersionOf(this.context.getServerVersion().getEquivalentTLSVersion()) ? new RSADigestSigner(digest) : new GenericSigner(this.createRSAImpl(), digest);
        signer.init(bl, cipherParameters);
        return signer;
    }

    protected AsymmetricBlockCipher createRSAImpl() {
        return new PKCS1Encoding(new RSABlindedEngine());
    }
}

