/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.modes.gcm;

import java.util.Vector;
import org.bouncycastle.crypto.modes.gcm.GCMExponentiator;
import org.bouncycastle.crypto.modes.gcm.GCMUtil;
import org.bouncycastle.util.Arrays;

public class Tables1kGCMExponentiator
implements GCMExponentiator {
    private Vector lookupPowX2;

    @Override
    public void init(byte[] byArray) {
        if (this.lookupPowX2 != null && Arrays.areEqual(byArray, (byte[])this.lookupPowX2.elementAt(0))) {
            return;
        }
        this.lookupPowX2 = new Vector(8);
        this.lookupPowX2.addElement(Arrays.clone(byArray));
    }

    @Override
    public void exponentiateX(long l, byte[] byArray) {
        byte[] byArray2 = GCMUtil.oneAsBytes();
        int n = 0;
        while (l > 0L) {
            if ((l & 1L) != 0L) {
                this.ensureAvailable(n);
                GCMUtil.multiply(byArray2, (byte[])this.lookupPowX2.elementAt(n));
            }
            ++n;
            l >>>= 1;
        }
        System.arraycopy(byArray2, 0, byArray, 0, 16);
    }

    private void ensureAvailable(int n) {
        int n2 = this.lookupPowX2.size();
        if (n2 <= n) {
            byte[] byArray = (byte[])this.lookupPowX2.elementAt(n2 - 1);
            do {
                byArray = Arrays.clone(byArray);
                GCMUtil.multiply(byArray, byArray);
                this.lookupPowX2.addElement(byArray);
            } while (++n2 <= n);
        }
    }
}

