/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oro.util;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.oro.util.Cache;
import org.apache.oro.util.GenericCacheEntry;

public abstract class GenericCache
implements Cache,
Serializable {
    private static final long serialVersionUID = 6123461456560210078L;
    public static final int DEFAULT_CAPACITY = 20;
    int _numEntries;
    GenericCacheEntry[] _cache;
    HashMap<Object, Object> _table;

    GenericCache(int n) {
        int n2 = n;
        this._numEntries = 0;
        this._table = new HashMap(n2);
        this._cache = new GenericCacheEntry[n2];
        while (--n2 >= 0) {
            this._cache[n2] = new GenericCacheEntry(n2);
        }
    }

    @Override
    public abstract void addElement(Object var1, Object var2);

    @Override
    public synchronized Object getElement(Object object) {
        Object object2 = this._table.get(object);
        if (object2 != null) {
            return ((GenericCacheEntry)object2)._value;
        }
        return null;
    }

    public final Iterator<Object> keys() {
        return this._table.keySet().iterator();
    }

    @Override
    public final int size() {
        return this._numEntries;
    }

    @Override
    public final int capacity() {
        return this._cache.length;
    }

    public final boolean isFull() {
        return this._numEntries >= this._cache.length;
    }
}

