/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oro.text.perl;

import org.apache.oro.text.PatternCache;
import org.apache.oro.text.PatternCacheLRU;
import org.apache.oro.text.perl.MalformedPerl5PatternException;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.MatchResult;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;
import org.apache.oro.util.Cache;
import org.apache.oro.util.CacheLRU;

public final class Perl5Util
implements MatchResult {
    private static final String __matchExpression = "m?(\\W)(.*)\\1([imsx]*)";
    private final PatternCache __patternCache;
    private final Cache __expressionCache;
    private final Perl5Matcher __matcher = new Perl5Matcher();
    private Pattern __matchPattern;
    private MatchResult __lastMatch;

    Perl5Util(PatternCache patternCache) {
        this.__patternCache = patternCache;
        this.__expressionCache = new CacheLRU(patternCache.capacity());
        this.__compilePatterns();
    }

    public Perl5Util() {
        this(new PatternCacheLRU());
    }

    private void __compilePatterns() {
        Perl5Compiler perl5Compiler = new Perl5Compiler();
        try {
            this.__matchPattern = perl5Compiler.compile(__matchExpression, 16);
        }
        catch (MalformedPatternException malformedPatternException) {
            throw new RuntimeException(malformedPatternException.getMessage());
        }
    }

    private Pattern __parseMatchExpression(String string) throws MalformedPerl5PatternException {
        Object object = this.__expressionCache.getElement(string);
        try {
            if (object != null) {
                return (Pattern)object;
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        if (!this.__matcher.matches(string, this.__matchPattern)) {
            throw new MalformedPerl5PatternException("Invalid expression: " + string);
        }
        MatchResult matchResult = this.__matcher.getMatch();
        String string2 = matchResult.group(2);
        int n = 0;
        String string3 = matchResult.group(3);
        if (string3 != null) {
            int n2 = string3.length();
            block8: while (n2-- > 0) {
                switch (string3.charAt(n2)) {
                    case 'i': {
                        n |= 1;
                        continue block8;
                    }
                    case 'm': {
                        n |= 8;
                        continue block8;
                    }
                    case 's': {
                        n |= 0x10;
                        continue block8;
                    }
                    case 'x': {
                        n |= 0x20;
                        continue block8;
                    }
                }
                throw new MalformedPerl5PatternException("Invalid options: " + string3);
            }
        }
        Pattern pattern = this.__patternCache.getPattern(string2, n);
        this.__expressionCache.addElement(string, pattern);
        return pattern;
    }

    public synchronized boolean match(String string, char[] cArray) throws MalformedPerl5PatternException {
        this.__parseMatchExpression(string);
        boolean bl = this.__matcher.contains(cArray, this.__parseMatchExpression(string));
        if (bl) {
            this.__lastMatch = this.__matcher.getMatch();
        }
        return bl;
    }

    public synchronized boolean match(String string, String string2) throws MalformedPerl5PatternException {
        return this.match(string, string2.toCharArray());
    }

    public synchronized MatchResult getMatch() {
        return this.__lastMatch;
    }

    @Override
    public synchronized int length() {
        return this.__lastMatch.length();
    }

    @Override
    public synchronized int groups() {
        return this.__lastMatch.groups();
    }

    @Override
    public synchronized String group(int n) {
        return this.__lastMatch.group(n);
    }

    @Override
    public synchronized int begin(int n) {
        return this.__lastMatch.begin(n);
    }

    @Override
    public synchronized int end(int n) {
        return this.__lastMatch.end(n);
    }

    @Override
    public synchronized int beginOffset(int n) {
        return this.__lastMatch.beginOffset(n);
    }

    @Override
    public synchronized int endOffset(int n) {
        return this.__lastMatch.endOffset(n);
    }

    @Override
    public synchronized String toString() {
        if (this.__lastMatch == null) {
            return null;
        }
        return this.__lastMatch.toString();
    }
}

