/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jmimemagic.detectors;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import net.sf.jmimemagic.MagicDetector;
import org.apache.oro.text.perl.Perl5Util;

public final class TextFileDetector
implements MagicDetector {
    @Override
    public String getDisplayName() {
        return "Text File Detector";
    }

    @Override
    public String getVersion() {
        return "0.1";
    }

    @Override
    public String[] getHandledExtensions() {
        return new String[]{"txt", "text"};
    }

    @Override
    public String[] getHandledTypes() {
        return new String[]{"text/plain"};
    }

    @Override
    public String getName() {
        return "textfiledetector";
    }

    @Override
    public String[] process(byte[] byArray, int n, int n2, long l, char c, String string, Map<String, String> map) {
        Perl5Util perl5Util = new Perl5Util();
        try {
            String string2 = new String(byArray, "UTF-8");
            if (!perl5Util.match("/[^[:ascii:][:space:]]/", string2)) {
                return new String[]{"text/plain"};
            }
            return null;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    @Override
    public String[] process(File file, int n, int n2, long l, char c, String string, Map<String, String> map) {
        return new String[0];
    }
}

