/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jmimemagic;

import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import net.sf.jmimemagic.MagicMatch;
import net.sf.jmimemagic.MagicMatcher;
import net.sf.jmimemagic.MagicParseException;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public final class MagicParser
extends DefaultHandler {
    private static String magicFile = "/magic.xml";
    private boolean initialized = false;
    private XMLReader parser = null;
    private final ArrayList<MagicMatcher> stack = new ArrayList();
    private final Collection<MagicMatcher> matchers = new ArrayList<MagicMatcher>();
    private MagicMatcher matcher = null;
    private MagicMatch match = null;
    private HashMap<String, String> properties = null;
    private String finalValue = "";
    private boolean isMimeType = false;
    private boolean isExtension = false;
    private boolean isDescription = false;
    private boolean isTest = false;

    public synchronized void initialize() throws MagicParseException {
        if (!this.initialized) {
            try {
                this.parser = (XMLReader)MagicMatcher.classForName("com.sun.org.apache.xerces.internal.parsers.SAXParser").newInstance();
            }
            catch (Exception exception) {
                try {
                    this.parser = XMLReaderFactory.createXMLReader();
                }
                catch (Exception exception2) {
                    throw new MagicParseException("unable to instantiate parser");
                }
            }
            this.parser.setErrorHandler(this);
            this.parser.setContentHandler(this);
            try {
                String string = MagicParser.class.getResource(magicFile).toString();
                if (string == null) {
                    throw new MagicParseException("couldn't load '" + string + "'");
                }
                this.parser.parse(string);
            }
            catch (SAXParseException sAXParseException) {
            }
            catch (Exception exception) {
                throw new MagicParseException("parse error occurred - " + exception.getMessage());
            }
            this.initialized = true;
        }
    }

    public Collection<MagicMatcher> getMatchers() {
        return this.matchers;
    }

    @Override
    public void startDocument() throws SAXException {
    }

    @Override
    public void endDocument() throws SAXException {
    }

    @Override
    public void processingInstruction(String string, String string2) throws SAXException {
    }

    @Override
    public void characters(char[] cArray, int n, int n2) throws SAXException {
        String string = new String(cArray, n, n2);
        this.finalValue = this.finalValue + string;
    }

    @Override
    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (string2.equals("match")) {
            this.match = new MagicMatch();
            this.matcher = new MagicMatcher();
            this.matcher.setMatch(this.match);
        }
        if (this.matcher != null) {
            if (string2.equals("mimetype")) {
                this.isMimeType = true;
            } else if (string2.equals("extension")) {
                this.isExtension = true;
            } else if (string2.equals("description")) {
                this.isDescription = true;
            } else if (string2.equals("test")) {
                this.isTest = true;
                int n = attributes.getLength();
                for (int i = 0; i < n; ++i) {
                    String string4 = attributes.getLocalName(i);
                    String string5 = attributes.getValue(i);
                    if (string4.equals("offset")) {
                        if (string5.equals("")) continue;
                        this.match.setOffset(new Integer(string5));
                        continue;
                    }
                    if (string4.equals("length")) {
                        if (string5.equals("")) continue;
                        this.match.setLength(new Integer(string5));
                        continue;
                    }
                    if (string4.equals("type")) {
                        this.match.setType(string5);
                        continue;
                    }
                    if (string4.equals("bitmask")) {
                        if (string5.equals("")) continue;
                        this.match.setBitmask(string5);
                        continue;
                    }
                    if (!string4.equals("comparator")) continue;
                    this.match.setComparator(string5);
                }
            } else if (string2.equals("property")) {
                int n = attributes.getLength();
                String string6 = null;
                String string7 = null;
                for (int i = 0; i < n; ++i) {
                    String string8 = attributes.getLocalName(i);
                    String string9 = attributes.getValue(i);
                    if (string8.equals("name")) {
                        if (string9.equals("")) continue;
                        string6 = string9;
                        continue;
                    }
                    if (!string8.equals("value") || string9.equals("")) continue;
                    string7 = string9;
                }
                if (string6 != null && string7 != null) {
                    if (this.properties == null) {
                        this.properties = new HashMap();
                    }
                    if (!this.properties.containsKey(string6)) {
                        this.properties.put(string6, string7);
                    }
                }
            } else if (string2.equals("match-list")) {
                this.stack.add(this.matcher);
            }
        }
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        if (this.isMimeType) {
            this.isMimeType = false;
            this.match.setMimeType(this.finalValue);
        } else if (this.isExtension) {
            this.isExtension = false;
            this.match.setExtension(this.finalValue);
        } else if (this.isDescription) {
            this.isDescription = false;
            this.match.setDescription(this.finalValue);
        } else if (this.isTest) {
            this.isTest = false;
            this.match.setTest(MagicParser.convertOctals(this.finalValue));
        }
        this.finalValue = "";
        if (string2.equals("match")) {
            if (this.matcher.isValid()) {
                this.match.setProperties(this.properties);
                if (this.stack.size() == 0) {
                    this.matchers.add(this.matcher);
                } else {
                    MagicMatcher magicMatcher = this.stack.get(this.stack.size() - 1);
                    magicMatcher.addSubMatcher(this.matcher);
                }
            }
            this.matcher = null;
            this.properties = null;
        } else if (string2.equals("match-list")) {
            if (this.stack.size() > 0) {
                this.matcher = this.stack.get(this.stack.size() - 1);
                this.stack.remove(this.matcher);
            }
        } else if (string2.equals("mimetype")) {
            this.isMimeType = false;
        } else if (string2.equals("extension")) {
            this.isExtension = false;
        } else if (string2.equals("description")) {
            this.isDescription = false;
        } else if (string2.equals("test")) {
            this.isTest = false;
        }
    }

    @Override
    public void warning(SAXParseException sAXParseException) throws SAXException {
    }

    @Override
    public void error(SAXParseException sAXParseException) throws SAXException {
        throw sAXParseException;
    }

    @Override
    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        throw sAXParseException;
    }

    private static ByteBuffer convertOctals(String string) {
        int n = 0;
        int n2 = 0;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        while ((n2 = string.indexOf(92, n)) != -1) {
            if (string.charAt(n2 + 1) != '\\') {
                for (int i = n; i < n2; ++i) {
                    byteArrayOutputStream.write(string.charAt(i));
                }
                if (n2 + 4 <= string.length()) {
                    try {
                        int n3 = Integer.parseInt(string.substring(n2 + 1, n2 + 4), 8);
                        byteArrayOutputStream.write(n3);
                        n2 = n = n2 + 4;
                    }
                    catch (NumberFormatException numberFormatException) {
                        byteArrayOutputStream.write(92);
                        n2 = n = n2 + 1;
                    }
                    continue;
                }
                byteArrayOutputStream.write(92);
                n2 = n = n2 + 1;
                continue;
            }
            byteArrayOutputStream.write(92);
            n2 = n = n2 + 1;
        }
        if (n2 < string.length()) {
            for (int i = n; i < string.length(); ++i) {
                byteArrayOutputStream.write(string.charAt(i));
            }
        }
        try {
            ByteBuffer byteBuffer = ByteBuffer.allocate(byteArrayOutputStream.size());
            return byteBuffer.put(byteArrayOutputStream.toByteArray());
        }
        catch (Exception exception) {
            return ByteBuffer.allocate(0);
        }
    }
}

