/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jmimemagic;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Logger;
import net.sf.jmimemagic.MagicMatch;
import net.sf.jmimemagic.UnsupportedTypeException;
import org.apache.oro.text.perl.Perl5Util;

public class MagicMatcher
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -1109707428218614961L;
    private final ArrayList<MagicMatcher> subMatchers = new ArrayList(0);
    private MagicMatch match = null;

    public void setMatch(MagicMatch magicMatch) {
        this.match = magicMatch;
    }

    public MagicMatch getMatch() {
        return this.match;
    }

    public boolean isValid() {
        if (this.match == null || this.match.getTest() == null) {
            return false;
        }
        String string = new String(this.match.getTest().array());
        char c = this.match.getComparator();
        String string2 = this.match.getDescription();
        String string3 = new String(this.match.getTest().array());
        return !string.equals("") && c != '\u0000' && (c == '=' || c == '!' || c == '>' || c == '<') && string2 != null && !string2.equals("") && !string3.equals("");
    }

    public void addSubMatcher(MagicMatcher magicMatcher) {
        this.subMatchers.add(magicMatcher);
    }

    public void setSubMatchers(Collection<MagicMatcher> collection) {
        this.subMatchers.clear();
        this.subMatchers.addAll(collection);
    }

    public Collection<MagicMatcher> getSubMatchers() {
        return this.subMatchers;
    }

    public MagicMatch test(File file, boolean bl) throws IOException, UnsupportedTypeException {
        int n = this.match.getOffset();
        this.match.getDescription();
        String string = this.match.getType();
        this.match.getMimeType();
        RandomAccessFile randomAccessFile = new RandomAccessFile(file, "r");
        int n2 = 0;
        if (string.equals("byte")) {
            n2 = 1;
        } else if (string.equals("short") || string.equals("leshort") || string.equals("beshort")) {
            n2 = 4;
        } else if (string.equals("long") || string.equals("lelong") || string.equals("belong")) {
            n2 = 8;
        } else if (string.equals("string")) {
            n2 = this.match.getTest().capacity();
        } else if (string.equals("regex")) {
            n2 = (int)randomAccessFile.length() - n;
            if (n2 < 0) {
                n2 = 0;
            }
        } else if (string.equals("detector")) {
            n2 = (int)randomAccessFile.length() - n;
            if (n2 < 0) {
                n2 = 0;
            }
        } else {
            randomAccessFile.close();
            throw new UnsupportedTypeException("unsupported test type '" + string + "'");
        }
        if ((long)n2 > randomAccessFile.length() - (long)n) {
            randomAccessFile.close();
            return null;
        }
        byte[] byArray = new byte[n2];
        randomAccessFile.seek(n);
        int n3 = 0;
        int n4 = 0;
        boolean bl2 = false;
        while (!bl2) {
            n4 = randomAccessFile.read(byArray, 0, n2 - n3);
            if (n4 == -1) {
                randomAccessFile.close();
                throw new IOException("reached end of file before all bytes were read");
            }
            if ((n3 += n4) != n2) continue;
            bl2 = true;
        }
        MagicMatch magicMatch = null;
        MagicMatch magicMatch2 = null;
        if (this.testInternal(byArray)) {
            magicMatch = this.getMatch();
            if (!bl && this.subMatchers != null && this.subMatchers.size() > 0) {
                for (int i = 0; i < this.subMatchers.size(); ++i) {
                    MagicMatcher magicMatcher = this.subMatchers.get(i);
                    magicMatch2 = magicMatcher.test(file, false);
                    if (magicMatch2 == null) continue;
                    magicMatch.addSubMatch(magicMatch2);
                }
            }
        }
        randomAccessFile.close();
        return magicMatch;
    }

    public MagicMatch test(byte[] byArray, boolean bl) throws IOException, UnsupportedTypeException {
        int n = this.match.getOffset();
        this.match.getDescription();
        String string = this.match.getType();
        this.match.getMimeType();
        int n2 = 0;
        if (string.equals("byte")) {
            n2 = 1;
        } else if (string.equals("short") || string.equals("leshort") || string.equals("beshort")) {
            n2 = 4;
        } else if (string.equals("long") || string.equals("lelong") || string.equals("belong")) {
            n2 = 8;
        } else if (string.equals("string")) {
            n2 = this.match.getTest().capacity();
        } else if (string.equals("regex")) {
            n2 = byArray.length - n - 1;
            if (n2 < 0) {
                n2 = 0;
            }
        } else if (string.equals("detector")) {
            n2 = byArray.length - n - 1;
            if (n2 < 0) {
                n2 = 0;
            }
        } else {
            throw new UnsupportedTypeException("unsupported test type " + string);
        }
        byte[] byArray2 = new byte[n2];
        if (n + n2 < byArray.length) {
            System.arraycopy(byArray, n, byArray2, 0, n2);
            MagicMatch magicMatch = null;
            MagicMatch magicMatch2 = null;
            if (this.testInternal(byArray2)) {
                magicMatch = this.getMatch();
                if (!bl && this.subMatchers != null && this.subMatchers.size() > 0) {
                    for (int i = 0; i < this.subMatchers.size(); ++i) {
                        MagicMatcher magicMatcher = this.subMatchers.get(i);
                        magicMatch2 = magicMatcher.test(byArray, false);
                        if (magicMatch2 == null) continue;
                        magicMatch.addSubMatch(magicMatch2);
                    }
                }
            }
            return magicMatch;
        }
        return null;
    }

    private boolean testInternal(byte[] byArray) {
        if (byArray.length == 0) {
            return false;
        }
        String string = this.match.getType();
        String string2 = new String(this.match.getTest().array());
        this.match.getMimeType();
        this.match.getDescription();
        ByteBuffer byteBuffer = ByteBuffer.allocate(byArray.length);
        if (string != null && string2.length() > 0) {
            if (string.equals("string")) {
                byteBuffer = byteBuffer.put(byArray);
                return this.testString(byteBuffer);
            }
            if (string.equals("byte")) {
                byteBuffer = byteBuffer.put(byArray);
                return this.testByte(byteBuffer);
            }
            if (string.equals("short")) {
                byteBuffer = byteBuffer.put(byArray);
                return this.testShort(byteBuffer);
            }
            if (string.equals("leshort")) {
                byteBuffer = byteBuffer.put(byArray);
                byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
                return this.testShort(byteBuffer);
            }
            if (string.equals("beshort")) {
                byteBuffer = byteBuffer.put(byArray);
                byteBuffer.order(ByteOrder.BIG_ENDIAN);
                return this.testShort(byteBuffer);
            }
            if (string.equals("long")) {
                byteBuffer = byteBuffer.put(byArray);
                return this.testLong(byteBuffer);
            }
            if (string.equals("lelong")) {
                byteBuffer = byteBuffer.put(byArray);
                byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
                return this.testLong(byteBuffer);
            }
            if (string.equals("belong")) {
                byteBuffer = byteBuffer.put(byArray);
                byteBuffer.order(ByteOrder.BIG_ENDIAN);
                return this.testLong(byteBuffer);
            }
            if (string.equals("regex")) {
                return this.testRegex(new String(byArray));
            }
            if (string.equals("detector")) {
                byteBuffer = byteBuffer.put(byArray);
                return this.testDetector(byteBuffer);
            }
        }
        return false;
    }

    private boolean testByte(ByteBuffer byteBuffer) {
        String string = new String(this.match.getTest().array());
        char c = this.match.getComparator();
        long l = this.match.getBitmask();
        byte by = (byte)((long)byteBuffer.get(0) & l);
        byte by2 = Integer.decode(string).byteValue();
        byte by3 = (byte)(by2 & 0xFF);
        switch (c) {
            case '=': {
                return by3 == by;
            }
            case '!': {
                return by3 != by;
            }
            case '>': {
                return by3 > by;
            }
            case '<': {
                return by3 < by;
            }
        }
        return false;
    }

    private boolean testString(ByteBuffer byteBuffer) {
        ByteBuffer byteBuffer2 = this.match.getTest();
        char c = this.match.getComparator();
        byte[] byArray = byteBuffer.array();
        byte[] byArray2 = byteBuffer2.array();
        boolean bl = false;
        int n = 0;
        for (n = 0; n < byArray2.length; ++n) {
            if (byArray2[n] == byArray[n]) continue;
            bl = true;
            break;
        }
        switch (c) {
            case '=': {
                return !bl;
            }
            case '!': {
                return bl;
            }
            case '>': {
                return byArray2[n] > byArray[n];
            }
            case '<': {
                return byArray2[n] < byArray[n];
            }
        }
        return false;
    }

    private boolean testShort(ByteBuffer byteBuffer) {
        short s = 0;
        String string = new String(this.match.getTest().array());
        char c = this.match.getComparator();
        long l = this.match.getBitmask();
        s = MagicMatcher.byteArrayToShort(byteBuffer);
        s = (short)(s & (short)l);
        short s2 = 0;
        try {
            s2 = Integer.decode(string).shortValue();
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        switch (c) {
            case '=': {
                return s == s2;
            }
            case '!': {
                return s != s2;
            }
            case '>': {
                return s > s2;
            }
            case '<': {
                return s < s2;
            }
        }
        return false;
    }

    private boolean testLong(ByteBuffer byteBuffer) {
        long l = 0L;
        String string = new String(this.match.getTest().array());
        char c = this.match.getComparator();
        long l2 = this.match.getBitmask();
        l = MagicMatcher.byteArrayToLong(byteBuffer);
        l &= l2;
        long l3 = Long.decode(string);
        switch (c) {
            case '=': {
                return l == l3;
            }
            case '!': {
                return l != l3;
            }
            case '>': {
                return l > l3;
            }
            case '<': {
                return l < l3;
            }
        }
        return false;
    }

    private boolean testRegex(String string) {
        String string2 = new String(this.match.getTest().array());
        char c = this.match.getComparator();
        Perl5Util perl5Util = new Perl5Util();
        if (c == '=') {
            return perl5Util.match(string2, string);
        }
        if (c == '!') {
            return !perl5Util.match(string2, string);
        }
        return false;
    }

    private boolean testDetector(ByteBuffer byteBuffer) {
        String string = new String(this.match.getTest().array());
        try {
            Class<?> clazz = MagicMatcher.classForName(string);
            Object obj = clazz.newInstance();
            Method method = clazz.getDeclaredMethod("process", byte[].class, Integer.TYPE, Integer.TYPE, Long.TYPE, Character.TYPE, String.class, Map.class);
            String[] stringArray = (String[])method.invoke(obj, byteBuffer.array(), this.match.getOffset(), this.match.getLength(), this.match.getBitmask(), Character.valueOf(this.match.getComparator()), this.match.getMimeType(), this.match.getProperties());
            if (stringArray != null && stringArray.length > 0) {
                this.match.setMimeType(stringArray[0]);
                return true;
            }
        }
        catch (Throwable throwable) {
            Logger.getAnonymousLogger().warning(throwable.toString());
        }
        return false;
    }

    public String[] getDetectorExtensions() {
        String string = new String(this.match.getTest().array()).trim();
        try {
            Class<?> clazz = MagicMatcher.classForName(string);
            Object obj = clazz.newInstance();
            Method method = clazz.getDeclaredMethod("getHandledTypes", new Class[0]);
            return (String[])method.invoke(obj, new Object[0]);
        }
        catch (Exception exception) {
            Logger.getLogger("es.gob.afirma").warning("Error cargando e instanciando la clase " + string + ": " + exception);
            exception.printStackTrace();
            return new String[0];
        }
    }

    private static short byteArrayToShort(ByteBuffer byteBuffer) {
        return byteBuffer.getShort(0);
    }

    private static long byteArrayToLong(ByteBuffer byteBuffer) {
        return byteBuffer.getInt(0);
    }

    protected Object clone() throws CloneNotSupportedException {
        MagicMatcher magicMatcher = new MagicMatcher();
        magicMatcher.setMatch((MagicMatch)this.match.clone());
        Iterator<MagicMatcher> iterator = this.subMatchers.iterator();
        ArrayList<MagicMatcher> arrayList = new ArrayList<MagicMatcher>();
        while (iterator.hasNext()) {
            MagicMatcher magicMatcher2 = iterator.next();
            arrayList.add((MagicMatcher)magicMatcher2.clone());
        }
        magicMatcher.setSubMatchers(arrayList);
        return magicMatcher;
    }

    static Class<?> classForName(String string) throws ClassNotFoundException {
        return MagicMatcher.getCleanClassLoader().loadClass(string);
    }

    private static ClassLoader getCleanClassLoader() {
        ClassLoader classLoader = MagicMatcher.class.getClassLoader();
        if (classLoader instanceof URLClassLoader && !classLoader.getClass().toString().contains("sun.plugin2.applet.JNLP2ClassLoader")) {
            ArrayList<URL> arrayList = new ArrayList<URL>();
            for (URL uRL : ((URLClassLoader)classLoader).getURLs()) {
                if (!uRL.toString().endsWith(".jar")) continue;
                arrayList.add(uRL);
            }
            classLoader = new URLClassLoader(arrayList.toArray(new URL[0]));
        }
        return classLoader;
    }
}

