/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jmimemagic;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class MagicMatch
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -1070505530849518849L;
    private String mimeType = null;
    private String extension = null;
    private String description = null;
    private byte[] test = null;
    private int offset = 0;
    private int length = 0;
    private String type = "";
    private long bitmask = 0xFFFFFFFFL;
    private char comparator = '\u0000';
    private final ArrayList<MagicMatch> subMatches = new ArrayList(0);
    private Map<String, String> properties;

    void setMimeType(String string) {
        this.mimeType = string;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    void setExtension(String string) {
        this.extension = string;
    }

    public String getExtension() {
        return this.extension;
    }

    void setDescription(String string) {
        this.description = string;
    }

    public String getDescription() {
        return this.description;
    }

    public void setTest(ByteBuffer byteBuffer) {
        this.test = byteBuffer.array();
    }

    public ByteBuffer getTest() {
        return ByteBuffer.wrap(this.test);
    }

    public void setOffset(int n) {
        this.offset = n;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setLength(int n) {
        this.length = n;
    }

    public int getLength() {
        return this.length;
    }

    public void setType(String string) {
        this.type = string;
    }

    public String getType() {
        return this.type;
    }

    public void setBitmask(String string) {
        if (string != null) {
            this.bitmask = Long.decode(string).intValue();
        }
    }

    public long getBitmask() {
        return this.bitmask;
    }

    public void setComparator(String string) {
        this.comparator = string.charAt(0);
    }

    public char getComparator() {
        return this.comparator;
    }

    public void setProperties(Map<String, String> map) {
        this.properties = map;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void addSubMatch(MagicMatch magicMatch) {
        this.subMatches.add(magicMatch);
    }

    public void setSubMatches(Collection<MagicMatch> collection) {
        this.subMatches.clear();
        this.subMatches.addAll(collection);
    }

    public Collection<MagicMatch> getSubMatches() {
        return this.subMatches;
    }

    public boolean descriptionMatches(String string) {
        if (this.description != null && this.description.equals(string)) {
            return true;
        }
        Collection<MagicMatch> collection = this.getSubMatches();
        Iterator<MagicMatch> iterator = collection.iterator();
        MagicMatch magicMatch = null;
        while (iterator.hasNext()) {
            magicMatch = iterator.next();
            if (!magicMatch.descriptionMatches(string)) continue;
            return true;
        }
        return false;
    }

    public boolean mimeTypeMatches(String string) {
        if (this.mimeType != null && this.mimeType.equals(string)) {
            return true;
        }
        Collection<MagicMatch> collection = this.getSubMatches();
        Iterator<MagicMatch> iterator = collection.iterator();
        MagicMatch magicMatch = null;
        while (iterator.hasNext()) {
            magicMatch = iterator.next();
            if (!magicMatch.mimeTypeMatches(string)) continue;
            return true;
        }
        return false;
    }

    protected Object clone() throws CloneNotSupportedException {
        MagicMatch magicMatch = new MagicMatch();
        magicMatch.setBitmask(Long.toString(this.bitmask, 8));
        magicMatch.setComparator("" + this.comparator);
        magicMatch.setDescription(this.description);
        magicMatch.setExtension(this.extension);
        magicMatch.setLength(this.length);
        magicMatch.setMimeType(this.mimeType);
        magicMatch.setOffset(this.offset);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.putAll(this.properties);
        magicMatch.setProperties(hashMap);
        Iterator<MagicMatch> iterator = this.subMatches.iterator();
        ArrayList<MagicMatch> arrayList = new ArrayList<MagicMatch>();
        while (iterator.hasNext()) {
            MagicMatch magicMatch2 = iterator.next();
            arrayList.add(magicMatch2);
        }
        magicMatch.setSubMatches(arrayList);
        magicMatch.setTest(ByteBuffer.wrap(this.test));
        magicMatch.setType(this.type);
        return magicMatch;
    }
}

