/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jmimemagic;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import net.sf.jmimemagic.MagicException;
import net.sf.jmimemagic.MagicMatch;
import net.sf.jmimemagic.MagicMatchNotFoundException;
import net.sf.jmimemagic.MagicMatcher;
import net.sf.jmimemagic.MagicParseException;
import net.sf.jmimemagic.MagicParser;

public class Magic {
    private static boolean initialized = false;
    private static MagicParser magicParser = null;
    private static HashMap<String, ArrayList<MagicMatcher>> hintMap = new HashMap();

    private static void addHint(String string, MagicMatcher magicMatcher) {
        if (hintMap.keySet().contains(string)) {
            ArrayList<MagicMatcher> arrayList = hintMap.get(string);
            arrayList.add(magicMatcher);
        } else {
            ArrayList<MagicMatcher> arrayList = new ArrayList<MagicMatcher>();
            arrayList.add(magicMatcher);
            hintMap.put(string, arrayList);
        }
    }

    public static synchronized void initialize() throws MagicParseException {
        if (!initialized) {
            magicParser = new MagicParser();
            magicParser.initialize();
            for (MagicMatcher magicMatcher : magicParser.getMatchers()) {
                String[] stringArray;
                String string = magicMatcher.getMatch().getExtension();
                if (string != null && !string.trim().equals("")) {
                    Magic.addHint(string, magicMatcher);
                    continue;
                }
                if (!magicMatcher.getMatch().getType().equals("detector")) continue;
                for (String string2 : stringArray = magicMatcher.getDetectorExtensions()) {
                    Magic.addHint(string2, magicMatcher);
                }
            }
            initialized = true;
        }
    }

    public static MagicMatch getMagicMatch(byte[] byArray) throws MagicParseException, MagicMatchNotFoundException, MagicException {
        return Magic.getMagicMatch(byArray, false);
    }

    public static MagicMatch getMagicMatch(byte[] byArray, boolean bl) throws MagicParseException, MagicMatchNotFoundException, MagicException {
        if (!initialized) {
            Magic.initialize();
        }
        Collection<MagicMatcher> collection = magicParser.getMatchers();
        MagicMatcher magicMatcher2 = null;
        MagicMatch magicMatch = null;
        for (MagicMatcher magicMatcher2 : collection) {
            try {
                magicMatch = magicMatcher2.test(byArray, bl);
                if (magicMatch == null) continue;
                return magicMatch;
            }
            catch (Throwable throwable) {
                throw new MagicException(throwable);
            }
        }
        throw new MagicMatchNotFoundException();
    }
}

