/*
 * Decompiled with CFR 0.152.
 */
package net.java.xades.util;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.java.xades.util.DOMOutputImpl;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSSerializer;

public class XMLUtils {
    private static Charset charset = Charset.forName("UTF-8");

    public static String getAttributeByName(Node node, String name) {
        if (node == null) {
            return null;
        }
        Node attribute = node.getAttributes().getNamedItem(name);
        if (attribute == null) {
            return null;
        }
        return attribute.getNodeValue().trim();
    }

    public static String getElementTextValueDeprecated(Element parentNode) {
        Text text = XMLUtils.getElementTextNode(parentNode);
        if (text != null) {
            return text.getData();
        }
        return null;
    }

    public static void setElementTextValue(Element e, String data) {
        Text txt = XMLUtils.getElementTextNode(e);
        if (txt != null) {
            txt.setData(data);
        } else {
            txt = e.getOwnerDocument().createTextNode(data);
            e.appendChild(txt);
        }
    }

    public static void setElementCDataValue(Element e, String data) {
        CDATASection txt = XMLUtils.getElementCDataNode(e);
        if (txt != null) {
            txt.setData(data);
        } else {
            txt = e.getOwnerDocument().createCDATASection(data);
            e.appendChild(txt);
        }
    }

    public static String getElementCDataValue(Element e) {
        CDATASection text = XMLUtils.getElementCDataNode(e);
        if (text != null) {
            return text.getData().trim();
        }
        return null;
    }

    public static CDATASection getElementCDataNode(Element element) {
        return (CDATASection)XMLUtils.getChildNodeByType(element, (short)4);
    }

    public static Text getElementTextNode(Element element) {
        return (Text)XMLUtils.getChildNodeByType(element, (short)3);
    }

    private static Node getChildNodeByType(Element element, short nodeType) {
        if (element == null) {
            return null;
        }
        NodeList nodes = element.getChildNodes();
        if (nodes == null || nodes.getLength() < 1) {
            return null;
        }
        for (int i = 0; i < nodes.getLength(); ++i) {
            String data;
            Node node = nodes.item(i);
            short type = node.getNodeType();
            if (type != nodeType || (type == 3 || type == 4) && ((data = ((Text)node).getData()) == null || data.trim().length() < 1)) continue;
            return node;
        }
        return null;
    }

    public static void writeXML(File file, Node node) throws FileNotFoundException {
        XMLUtils.writeXML(new FileOutputStream(file), node);
    }

    public static void writeXML(OutputStream outStream, Node node) {
        XMLUtils.writeXML(new BufferedWriter(new OutputStreamWriter(outStream, charset)), node, true);
    }

    public static void writeXML(OutputStream outStream, Node node, boolean indent) {
        XMLUtils.writeXML(new BufferedWriter(new OutputStreamWriter(outStream, charset)), node, indent);
    }

    public static void writeXML(Writer writer, Node node, boolean indent) {
        Document document = null;
        if (node instanceof Element) {
            document = node.getOwnerDocument();
        } else if (node instanceof Document) {
            document = (Document)node;
        }
        DOMImplementationLS domImplLS = (DOMImplementationLS)((Object)document.getImplementation());
        LSSerializer serializer = domImplLS.createLSSerializer();
        serializer.getDomConfig().setParameter("namespaces", false);
        DOMOutputImpl output = new DOMOutputImpl();
        output.setCharacterStream(writer);
        serializer.write(node, output);
    }

    public static void writeXML(Writer writer, Document document, String doctypeSystem, String doctypePublic) {
        DOMImplementationLS domImplLS = (DOMImplementationLS)((Object)document.getImplementation());
        LSSerializer serializer = domImplLS.createLSSerializer();
        DOMOutputImpl output = new DOMOutputImpl();
        output.setCharacterStream(writer);
        serializer.write(document.getDocumentElement(), output);
    }

    public static Element getChildElementByChain(Element element, String[] chain, boolean create) {
        if (chain == null) {
            return null;
        }
        Element e = element;
        for (int i = 0; i < chain.length; ++i) {
            if (e == null) {
                return null;
            }
            e = XMLUtils.getChildElementByTagName(e, chain[i]);
        }
        return e;
    }

    public static Element createLastPathComponent(Document doc, String[] path) {
        Element parent = (Element)doc.getFirstChild();
        if (path == null || parent == null || doc == null) {
            throw new IllegalArgumentException("Document parent and path must not be null");
        }
        Element e = parent;
        for (int i = 0; i < path.length; ++i) {
            Element newEl = XMLUtils.getChildElementByTagName(e, path[i]);
            if (newEl == null) {
                newEl = doc.createElement(path[i]);
                e.appendChild(newEl);
            }
            e = newEl;
        }
        return e;
    }

    public static Element getChildElementByTagNameNS(Element parent, String tagName, String nsName) {
        NodeList nl = parent.getChildNodes();
        int size = nl.getLength();
        for (int i = 0; i < size; ++i) {
            String ns;
            Node node = nl.item(i);
            if (node.getNodeType() != 1 || !tagName.equals(node.getLocalName()) || (ns = node.getNamespaceURI()) == null || !ns.equals(nsName)) continue;
            return (Element)node;
        }
        return null;
    }

    public static Element getChildElementByTagName(Element parent, String tagName) {
        if (parent == null || tagName == null) {
            return null;
        }
        NodeList nodes = parent.getChildNodes();
        int len = nodes.getLength();
        for (int i = 0; i < len; ++i) {
            Node node = nodes.item(i);
            if (node.getNodeType() != 1 || !((Element)node).getNodeName().equals(tagName)) continue;
            return (Element)node;
        }
        return null;
    }

    public static List<Element> getChildElementsByTagNameNS(Element parent, String tagName, String nsName) {
        if (parent == null || tagName == null) {
            return Collections.emptyList();
        }
        NodeList nl = parent.getChildNodes();
        int size = nl.getLength();
        ArrayList<Element> childElements = new ArrayList<Element>(size);
        for (int i = 0; i < size; ++i) {
            String ns;
            Node node = nl.item(i);
            if (node.getNodeType() != 1 || !tagName.equals(node.getLocalName()) || (ns = node.getNamespaceURI()) == null || !ns.equals(nsName)) continue;
            childElements.add((Element)node);
        }
        return childElements;
    }

    public static List<Element> getChildElementsByTagName(Element parent, String tagName) {
        if (parent == null || tagName == null) {
            return Collections.emptyList();
        }
        NodeList nodes = parent.getChildNodes();
        int len = nodes.getLength();
        ArrayList<Element> childElements = new ArrayList<Element>(len);
        for (int i = 0; i < len; ++i) {
            Node node = nodes.item(i);
            if (node.getNodeType() != 1 || !((Element)node).getNodeName().equals(tagName)) continue;
            childElements.add((Element)node);
        }
        return childElements;
    }

    public static void printChildElements(Element parent, PrintStream out, boolean deep, String prefix) {
        Node node;
        out.print(prefix + "<" + parent.getNodeName());
        NamedNodeMap attrs = parent.getAttributes();
        for (int i = 0; i < attrs.getLength(); ++i) {
            node = attrs.item(i);
            out.print(" " + node.getNodeName() + "=\"" + node.getNodeValue() + "\"");
        }
        out.println(">");
        String data = parent.getNodeValue();
        if (data != null && data.trim().length() > 0) {
            out.println(prefix + "\t" + data);
        }
        if ((data = XMLUtils.getElementCDataValue(parent)) != null && data.trim().length() > 0) {
            out.println(prefix + "\t<![CDATA[" + data + "]]>");
        }
        NodeList nodes = parent.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            node = nodes.item(i);
            if (node.getNodeType() != 1) continue;
            if (deep) {
                XMLUtils.printChildElements((Element)node, out, deep, prefix + "\t");
                continue;
            }
            out.println(prefix + node.getNodeName());
        }
        out.println(prefix + "</" + parent.getNodeName() + ">");
    }
}

