/*
 * Decompiled with CFR 0.152.
 */
package net.java.xades.security.xml.XAdES;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.java.xades.security.xml.XAdES.ArchivalXAdESImpl;
import net.java.xades.security.xml.XAdES.BasicXAdESImpl;
import net.java.xades.security.xml.XAdES.CompleteValidationXAdESImpl;
import net.java.xades.security.xml.XAdES.ExplicitPolicyXAdESImpl;
import net.java.xades.security.xml.XAdES.ExtendedLongXAdESImpl;
import net.java.xades.security.xml.XAdES.ExtendedXAdESImpl;
import net.java.xades.security.xml.XAdES.TimestampXAdESImpl;
import net.java.xades.security.xml.XAdES.XAdES_BES;
import net.java.xades.security.xml.XAdES.XadesElement;
import net.java.xades.security.xml.XAdES.XadesElementsEnumeration;
import net.java.xades.util.ObjectId;
import net.java.xades.util.OccursRequirement;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public enum XAdES {
    BES("XAdES-BES", "4.4.1", "Basic Electronic Signature"),
    EPES("XAdES-EPES", "4.4.2", "Explicit Policy Electronic Signatures"),
    T("XAdES-T", "4.4.3.1", "Electronic Signature with Time"),
    C("XAdES-C", "4.4.3.2", "Electronic Signature with Complete Validation Data References"),
    X("XAdES-X", "B.1", "Extended Signatures with Time Forms"),
    X_L("XAdES-X-L", "B.2", "Extended Long Electronic Signatures with Time"),
    A("XAdES-A", "B.3", "Archival Electronic Signatures");

    private String nickname;
    private String contentsId;
    private String title;
    public static final XadesElementsEnumeration XAdES_ELEMENTS;
    public static final XadesElementsEnumeration XAdES_BES_ELEMENTS;
    public static final XadesElementsEnumeration XAdES_EPES_ELEMENTS;
    public static final XadesElementsEnumeration XAdES_T_ELEMENTS;
    public static final XadesElementsEnumeration XAdES_C_ELEMENTS;
    public static final XadesElementsEnumeration XAdES_X_ELEMENTS;
    public static final XadesElementsEnumeration XAdES_X_L_ELEMENTS;
    public static final XadesElementsEnumeration XAdES_A_ELEMENTS;

    private XAdES(String nickname, String contentsId, String title) {
        this.nickname = nickname;
        this.contentsId = contentsId;
        this.title = title;
    }

    public String getNickname() {
        return this.nickname;
    }

    public String getContentsId() {
        return this.contentsId;
    }

    public String getTitle() {
        return this.title;
    }

    public static XAdES_BES newInstance(XAdES xades, org.w3c.dom.Element baseElement) {
        return XAdES.newInstance(xades, "http://uri.etsi.org/01903/v1.3.2#", "xades", "dsign", "http://www.w3.org/2000/09/xmldsig#sha1", baseElement.getOwnerDocument(), baseElement);
    }

    public static XAdES_BES newInstance(XAdES xades) {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.newDocument();
            return XAdES.newInstance(xades, "http://uri.etsi.org/01903/v1.3.2#", "xades", "dsign", "http://www.w3.org/2000/09/xmldsig#sha1", document, null);
        }
        catch (ParserConfigurationException e) {
            return null;
        }
    }

    public static XAdES_BES newInstance(XAdES xades, String xadesNamespace, String xadesPrefix, String xmlSignaturePrefix, String digestMethod, Document document, org.w3c.dom.Element baseElement) {
        XAdES.setDefinedIdAttributesAsDOMIds(document);
        if (BES.equals((Object)xades)) {
            return new BasicXAdESImpl(document, baseElement, false, xadesPrefix, xadesNamespace, xmlSignaturePrefix, digestMethod);
        }
        if (EPES.equals((Object)xades)) {
            return new ExplicitPolicyXAdESImpl(document, baseElement, false, xadesPrefix, xadesNamespace, xmlSignaturePrefix, digestMethod);
        }
        if (T.equals((Object)xades)) {
            return new TimestampXAdESImpl(document, baseElement, false, xadesPrefix, xadesNamespace, xmlSignaturePrefix, digestMethod);
        }
        if (C.equals((Object)xades)) {
            return new CompleteValidationXAdESImpl(document, baseElement, false, xadesPrefix, xadesNamespace, xmlSignaturePrefix, digestMethod);
        }
        if (X.equals((Object)xades)) {
            return new ExtendedXAdESImpl(document, baseElement, false, xadesPrefix, xadesNamespace, xmlSignaturePrefix, digestMethod);
        }
        if (X_L.equals((Object)xades)) {
            return new ExtendedLongXAdESImpl(document, baseElement, false, xadesPrefix, xadesNamespace, xmlSignaturePrefix, digestMethod);
        }
        if (A.equals((Object)xades)) {
            return new ArchivalXAdESImpl(document, baseElement, false, xadesPrefix, xadesNamespace, xmlSignaturePrefix, digestMethod);
        }
        throw new IllegalArgumentException("Unknown XAdES type: " + (Object)((Object)xades));
    }

    private static void setDefinedIdAttributesAsDOMIds(Document document) {
        NodeList nodes = document.getElementsByTagName("*");
        for (int i = 0; i < nodes.getLength(); ++i) {
            org.w3c.dom.Element node = (org.w3c.dom.Element)nodes.item(i);
            if (node.getAttribute("Id") == null || node.getAttribute("Id").isEmpty()) continue;
            node.setIdAttributeNS(null, "Id", true);
        }
    }

    static {
        XAdES_ELEMENTS = new XadesElementsEnumeration(Element.values());
        XAdES_BES_ELEMENTS = new XadesElementsEnumeration(Element.values(), BES);
        XAdES_EPES_ELEMENTS = new XadesElementsEnumeration(Element.values(), EPES);
        XAdES_T_ELEMENTS = new XadesElementsEnumeration(Element.values(), T);
        XAdES_C_ELEMENTS = new XadesElementsEnumeration(Element.values(), C);
        XAdES_X_ELEMENTS = new XadesElementsEnumeration(Element.values(), X);
        XAdES_X_L_ELEMENTS = new XadesElementsEnumeration(Element.values(), X_L);
        XAdES_A_ELEMENTS = new XadesElementsEnumeration(Element.values(), A);
    }

    public static enum Element implements XadesElement
    {
        OBJECT(null, "Object"),
        QUALIFYING_PROPERTIES(OBJECT, "QualifyingProperties"),
        SIGNED_PROPERTIES(QUALIFYING_PROPERTIES, "SignedProperties"),
        SIGNED_SIGNATURE_PROPERTIES(SIGNED_PROPERTIES, "SignedSignatureProperties"),
        SIGNING_TIME(BES, SIGNED_SIGNATURE_PROPERTIES, "SigningTime", OccursRequirement.ZERO_OR_ONE),
        SIGNING_CERTIFICATE(BES, SIGNED_SIGNATURE_PROPERTIES, "SigningCertificate", OccursRequirement.ZERO_OR_ONE),
        SIGNATURE_POLICY_IDENTIFIER(EPES, SIGNED_SIGNATURE_PROPERTIES, "SignaturePolicyIdentifier", OccursRequirement.EXACTLY_ONE),
        SIGNATURE_PRODUCTION_PLACE(BES, SIGNED_SIGNATURE_PROPERTIES, "SignatureProductionPlace", OccursRequirement.ZERO_OR_ONE),
        SIGNER_ROLE(BES, SIGNED_SIGNATURE_PROPERTIES, "SignerRole", OccursRequirement.ZERO_OR_ONE),
        CLAIMED_ROLES(BES, SIGNER_ROLE, "ClaimedRoles", OccursRequirement.ZERO_OR_MORE),
        CERTIFIED_ROLES(BES, SIGNER_ROLE, "CertifiedRoles", OccursRequirement.ZERO_OR_MORE),
        SIGNER(BES, SIGNED_SIGNATURE_PROPERTIES, "Signer", OccursRequirement.ZERO_OR_ONE),
        SIGNER_DETAILS(BES, SIGNED_SIGNATURE_PROPERTIES, "SignerDetails", OccursRequirement.ZERO_OR_ONE),
        SIGNED_DATA_OBJECT_PROPERTIES(SIGNED_PROPERTIES, "SignedDataObjectProperties"),
        DATA_OBJECT_FORMATS(BES, SIGNED_DATA_OBJECT_PROPERTIES, "DataObjectFormat", OccursRequirement.ZERO_OR_MORE),
        COMMITMENT_TYPE_INDICATIONS(BES, SIGNED_DATA_OBJECT_PROPERTIES, "CommitmentTypeIndication", OccursRequirement.ZERO_OR_MORE),
        ALL_DATA_OBJECTS_TIMESTAMPS(BES, SIGNED_DATA_OBJECT_PROPERTIES, "AllDataObjectsTimeStamp", OccursRequirement.ZERO_OR_MORE),
        INDIVIDUAL_DATA_OBJECTS_TIMESTAMPS(BES, SIGNED_DATA_OBJECT_PROPERTIES, "IndividualDataObjectsTimeStamp", OccursRequirement.ZERO_OR_MORE),
        UNSIGNED_PROPERTIES(QUALIFYING_PROPERTIES, "UnsignedProperties"),
        UNSIGNED_SIGNATURE_PROPERTIES(UNSIGNED_PROPERTIES, "UnsignedSignatureProperties"),
        COUNTER_SIGNATURES(BES, UNSIGNED_SIGNATURE_PROPERTIES, "CounterSignature", OccursRequirement.ZERO_OR_MORE),
        SIGNATURE_TIME_STAMP(T, UNSIGNED_SIGNATURE_PROPERTIES, "SignatureTimeStamp", OccursRequirement.ONE_OR_MORE),
        COMPLETE_CERTIFICATE_REFS(C, UNSIGNED_SIGNATURE_PROPERTIES, "CompleteCertificateRefs", OccursRequirement.EXACTLY_ONE),
        COMPLETE_REVOCATION_REFS(C, UNSIGNED_SIGNATURE_PROPERTIES, "CompleteRevocationRefs", OccursRequirement.EXACTLY_ONE),
        ATTRIBUTE_CERTIFICATE_REFS(C, UNSIGNED_SIGNATURE_PROPERTIES, "AttributeCertificateRefs", OccursRequirement.ZERO_OR_ONE),
        ATTRIBUTE_REVOCATION_REFS(C, UNSIGNED_SIGNATURE_PROPERTIES, "CompleteCertificateRefs", OccursRequirement.ZERO_OR_ONE),
        QUALIFYING_PROPERTIES_REFERENCE(OBJECT, "QualifyingPropertiesReference");

        private XAdES xades;
        private ObjectId objectId;
        private String elementName;
        private OccursRequirement occursRequirement;
        private XadesElement parent;

        private Element(XadesElement parent, String elementName) {
            this(null, parent, elementName, OccursRequirement.EXACTLY_ONE);
        }

        private Element(XAdES xades, XadesElement parent, String elementName, OccursRequirement occursRequirement) {
            this.xades = xades;
            this.parent = parent;
            this.elementName = elementName;
            this.occursRequirement = OccursRequirement.EXACTLY_ONE;
        }

        @Override
        public XAdES getXAdES() {
            return this.xades;
        }

        @Override
        public ObjectId getObjectId() {
            if (this.objectId == null) {
                int[] components;
                if (this.parent != null) {
                    int[] parentComps = this.parent.getObjectId().getComponents();
                    int size = parentComps.length;
                    components = new int[size + 1];
                    System.arraycopy(parentComps, 0, components, 0, size);
                    components[size] = this.ordinal() + 1;
                } else {
                    components = new int[]{0, this.ordinal() + 1};
                }
                this.objectId = new ObjectId(components);
            }
            return this.objectId;
        }

        @Override
        public String getElementName() {
            return this.elementName;
        }

        @Override
        public OccursRequirement getOccursRequirement() {
            return this.occursRequirement;
        }

        @Override
        public XadesElement getParent() {
            return this.parent;
        }

        public String toString() {
            return "[" + this.getObjectId() + "] " + this.getElementName();
        }
    }
}

