/*
 * Decompiled with CFR 0.152.
 */
package es.gob.jmulticard.ui.passwordcallback.gui;

import es.gob.jmulticard.ui.passwordcallback.gui.GeneralConfig;
import java.awt.Color;
import java.awt.Font;
import java.awt.IllegalComponentStateException;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Locale;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.JWindow;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;

final class Utils {
    private static final boolean HIGH_CONTRAST;

    static boolean isHighContrast() {
        return HIGH_CONTRAST;
    }

    private Utils() {
    }

    static void remarcar(JComponent jComponent) {
        if (GeneralConfig.isRemarked()) {
            JComponent jComponent2;
            if (jComponent instanceof JButton) {
                jComponent2 = (JButton)jComponent;
                jComponent2.addFocusListener(new FocusListener((JButton)jComponent2){
                    final /* synthetic */ JButton val$button;
                    {
                        this.val$button = jButton;
                    }

                    @Override
                    public void focusLost(FocusEvent focusEvent) {
                        if (this.val$button.getParent() instanceof JPanel) {
                            ((JPanel)this.val$button.getParent()).setBorder(BorderFactory.createEmptyBorder());
                        }
                    }

                    @Override
                    public void focusGained(FocusEvent focusEvent) {
                        if (GeneralConfig.isHighContrast() || Utils.isHighContrast()) {
                            if (this.val$button.getParent() instanceof JPanel) {
                                ((JPanel)this.val$button.getParent()).setBorder(BorderFactory.createLineBorder(Color.WHITE, 2));
                            }
                        } else if (this.val$button.getParent() instanceof JPanel) {
                            ((JPanel)this.val$button.getParent()).setBorder(BorderFactory.createLineBorder(Color.BLACK, 2));
                        }
                    }
                });
            }
            if (jComponent instanceof JTextField) {
                jComponent2 = (JTextField)jComponent;
                jComponent2.addFocusListener(new FocusListener((JTextField)jComponent2){
                    final /* synthetic */ JTextField val$textField;
                    {
                        this.val$textField = jTextField;
                    }

                    @Override
                    public void focusLost(FocusEvent focusEvent) {
                        this.val$textField.setBorder(BorderFactory.createLineBorder(Color.GRAY, 1));
                    }

                    @Override
                    public void focusGained(FocusEvent focusEvent) {
                        if (GeneralConfig.isHighContrast() || Utils.isHighContrast()) {
                            this.val$textField.setBorder(BorderFactory.createLineBorder(Color.WHITE, 2));
                        } else {
                            this.val$textField.setBorder(BorderFactory.createLineBorder(Color.BLACK, 2));
                        }
                    }
                });
            }
            if (jComponent instanceof JComboBox) {
                jComponent2 = (JComboBox)jComponent;
                jComponent2.addFocusListener(new FocusListener((JComboBox)jComponent2){
                    final /* synthetic */ JComboBox val$comboBox;
                    {
                        this.val$comboBox = jComboBox;
                    }

                    @Override
                    public void focusLost(FocusEvent focusEvent) {
                        this.val$comboBox.setBorder(BorderFactory.createLineBorder(Color.GRAY, 1));
                    }

                    @Override
                    public void focusGained(FocusEvent focusEvent) {
                        if (GeneralConfig.isHighContrast() || Utils.isHighContrast()) {
                            this.val$comboBox.setBorder(BorderFactory.createLineBorder(Color.WHITE, 2));
                        } else {
                            this.val$comboBox.setBorder(BorderFactory.createLineBorder(Color.BLACK, 2));
                        }
                    }
                });
            }
            if (jComponent instanceof JLabel) {
                jComponent2 = (JLabel)jComponent;
                jComponent2.addFocusListener(new FocusListener((JLabel)jComponent2){
                    final /* synthetic */ JLabel val$label;
                    {
                        this.val$label = jLabel;
                    }

                    @Override
                    public void focusLost(FocusEvent focusEvent) {
                        this.val$label.setBorder(BorderFactory.createEmptyBorder());
                    }

                    @Override
                    public void focusGained(FocusEvent focusEvent) {
                        if (GeneralConfig.isHighContrast() || Utils.isHighContrast()) {
                            this.val$label.setBorder(BorderFactory.createLineBorder(Color.WHITE, 2));
                        } else {
                            this.val$label.setBorder(BorderFactory.createLineBorder(Color.BLACK, 2));
                        }
                    }
                });
            }
            if (jComponent instanceof JCheckBox) {
                jComponent2 = (JCheckBox)jComponent;
                jComponent2.addFocusListener(new FocusListener((JCheckBox)jComponent2){
                    final /* synthetic */ JCheckBox val$checkBox;
                    {
                        this.val$checkBox = jCheckBox;
                    }

                    @Override
                    public void focusLost(FocusEvent focusEvent) {
                        ((JPanel)this.val$checkBox.getParent()).setBorder(BorderFactory.createEmptyBorder());
                    }

                    @Override
                    public void focusGained(FocusEvent focusEvent) {
                        if (GeneralConfig.isHighContrast() || Utils.isHighContrast()) {
                            ((JPanel)this.val$checkBox.getParent()).setBorder(BorderFactory.createLineBorder(Color.WHITE, 2));
                        } else {
                            ((JPanel)this.val$checkBox.getParent()).setBorder(BorderFactory.createLineBorder(Color.BLACK, 2));
                        }
                    }
                });
            }
        }
    }

    static void setContrastColor(JComponent jComponent) {
        if (GeneralConfig.isHighContrast()) {
            if (jComponent instanceof JComboBox || jComponent instanceof JPasswordField || jComponent instanceof JTextField) {
                jComponent.setBackground(Color.WHITE);
            } else if (jComponent instanceof JCheckBox) {
                jComponent.setForeground(Color.WHITE);
            } else if (jComponent instanceof JPanel) {
                if (jComponent.getBorder() instanceof TitledBorder) {
                    ((TitledBorder)jComponent.getBorder()).setTitleColor(Color.WHITE);
                }
                jComponent.setForeground(Color.WHITE);
                jComponent.setBackground(Color.BLACK);
            } else {
                jComponent.setForeground(Color.WHITE);
                jComponent.setBackground(Color.BLACK);
            }
        }
    }

    static void setFontBold(JComponent jComponent) {
        if (jComponent instanceof JPanel) {
            TitledBorder titledBorder;
            if (jComponent.getBorder() instanceof TitledBorder && (titledBorder = (TitledBorder)jComponent.getBorder()) != null) {
                if (GeneralConfig.isFontBold()) {
                    titledBorder.setTitleFont(new Font(jComponent.getFont().getName(), 1, jComponent.getFont().getSize()));
                } else {
                    titledBorder.setTitleFont(new Font(jComponent.getFont().getName(), 0, jComponent.getFont().getSize()));
                }
            }
        } else if (GeneralConfig.isFontBold()) {
            jComponent.setFont(new Font(jComponent.getFont().getName(), 1, jComponent.getFont().getSize()));
        } else {
            jComponent.setFont(new Font(jComponent.getFont().getName(), 0, jComponent.getFont().getSize()));
        }
    }

    static String remarkMnemonic(String string, int n) {
        String string2 = string;
        int n2 = string.indexOf(n);
        if (n2 == -1) {
            char c = (char)n;
            n2 = string.indexOf(String.valueOf(c).toLowerCase(Locale.getDefault()));
        }
        if (n2 != -1) {
            string2 = string.substring(0, n2) + "<u>" + string.charAt(n2) + "</u>" + string.substring(n2 + 1);
        }
        return string2;
    }

    static void showToolTip(boolean bl, JWindow jWindow, JButton jButton, JLabel jLabel) {
        jLabel.setText(jButton.getToolTipText());
        jWindow.setBackground((Color)UIManager.get("ToolTip.background"));
        jLabel.setBackground((Color)UIManager.get("ToolTip.background"));
        jLabel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.BLACK), BorderFactory.createEmptyBorder(0, 3, 0, 3)));
        jLabel.setFont((Font)UIManager.get("ToolTip.font"));
        jLabel.setOpaque(true);
        jWindow.add(jLabel);
        Point point = new Point();
        try {
            point = jButton.getLocationOnScreen();
        }
        catch (IllegalComponentStateException illegalComponentStateException) {
            Logger.getLogger("es.gob.jmulticard").warning("Error mostrando el tooltip: " + illegalComponentStateException);
        }
        int n = 0;
        if (jButton.getSize().getHeight() > 34.0) {
            n = (int)(jButton.getSize().getHeight() * 0.5);
        }
        jWindow.setLocation((int)point.getX(), (int)point.getY() + 30 + n);
        jWindow.pack();
        jWindow.setVisible(bl);
    }

    static {
        Object object = Toolkit.getDefaultToolkit().getDesktopProperty("win.highContrast.on");
        HIGH_CONTRAST = object instanceof Boolean ? (Boolean)object : System.getProperty("os.name") != null && System.getProperty("os.name").contains("inux");
    }
}

