/*
 * Decompiled with CFR 0.152.
 */
package es.gob.jmulticard.ui.passwordcallback.gui;

import es.gob.jmulticard.ui.passwordcallback.gui.Constants;
import es.gob.jmulticard.ui.passwordcallback.gui.GeneralConfig;
import es.gob.jmulticard.ui.passwordcallback.gui.IconLabel;
import es.gob.jmulticard.ui.passwordcallback.gui.JAccessibilityCustomDialog;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.image.BufferedImage;
import javax.accessibility.Accessible;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;

final class ResizingAdaptor
extends ComponentAdapter {
    private final JAccessibilityCustomDialog theCustomDialog;

    ResizingAdaptor(JAccessibilityCustomDialog jAccessibilityCustomDialog) {
        this.theCustomDialog = jAccessibilityCustomDialog;
    }

    @Override
    public void componentResized(ComponentEvent componentEvent) {
        if (this.theCustomDialog != null) {
            this.adjustFontSize(this.theCustomDialog.getComponents());
        }
    }

    private void adjustFontSize(Component[] componentArray) {
        float f = 1.0f;
        if (this.theCustomDialog != null) {
            double d;
            double d2;
            if (GeneralConfig.isBigFontSize() || GeneralConfig.isFontBold() || this.theCustomDialog.isBigSizeDefault()) {
                d2 = this.theCustomDialog.getSize().getWidth() / (double)this.theCustomDialog.getInitialWidth();
                d = this.theCustomDialog.getSize().getHeight() / (double)this.theCustomDialog.getInitialHeight();
            } else {
                d2 = this.theCustomDialog.getSize().getWidth() / (double)this.theCustomDialog.getInitialWidth();
                d = this.theCustomDialog.getSize().getHeight() / (double)this.theCustomDialog.getInitialHeight();
            }
            f = Math.round(d2 * d * (double)this.theCustomDialog.getMinimumRelation());
        }
        for (Component component : componentArray) {
            Object object;
            Border border;
            Component component2 = component;
            if (ResizingAdaptor.isResizable(component2)) {
                if (f > 10.0f) {
                    float f2 = 0.0f;
                    f2 = this.theCustomDialog != null ? (float)Math.round(f / ResizingAdaptor.getResizingFactorCustomDialog()) : (float)Math.round(f / ResizingAdaptor.getResizingFactorFileChooser());
                    component2.setFont(component2.getFont().deriveFont(ResizingAdaptor.getFontSize() + f2));
                } else {
                    if (component2 instanceof JComboBox) {
                        component2.setPreferredSize(new Dimension(100, 25));
                    }
                    component2.setFont(component2.getFont().deriveFont(ResizingAdaptor.getFontSize()));
                }
            }
            if (component2 instanceof JPanel && (border = ((JPanel)component2).getBorder()) instanceof TitledBorder && ((object = component2.getName()) == null || !((String)object).equalsIgnoreCase("AccessibilityButtonsPanel"))) {
                TitledBorder titledBorder = (TitledBorder)border;
                float f3 = Math.round(f / ResizingAdaptor.getResizingFactorFrame());
                if (titledBorder.getTitleFont() != null) {
                    titledBorder.setTitleFont(titledBorder.getTitleFont().deriveFont(ResizingAdaptor.getFontSize() - 2.0f + f3));
                } else {
                    titledBorder.setTitleFont(component2.getFont().deriveFont(ResizingAdaptor.getFontSize() - 2.0f + f3));
                }
            }
            if (component2 instanceof Container && !(component2 instanceof JComboBox)) {
                Container container = (Container)component2;
                this.adjustFontSize(container.getComponents());
            }
            if (component2 instanceof IconLabel && ((IconLabel)(object = (IconLabel)component2)).getOriginalIcon() != null) {
                float f4 = this.getImageResizeFactor(0.0015);
                int n = ((IconLabel)object).getOriginalDimension().width;
                int n2 = ((IconLabel)object).getOriginalDimension().height;
                ResizingAdaptor.resizeImage(f4, component2, n, n2, 4);
            }
            if (!(component2 instanceof JButton) || ((JButton)component2).getIcon() == null) continue;
            float f5 = 0.0f;
            f5 = this.theCustomDialog != null ? this.getImageResizeFactor(0.0025) : this.getImageResizeFactor(0.0015);
            ResizingAdaptor.resizeImageButton(f5, component2);
        }
    }

    private float getImageResizeFactor(double d) {
        float f = 0.0f;
        if (this.theCustomDialog != null) {
            f = (float)((double)this.theCustomDialog.getHeight() * d);
        }
        return f;
    }

    private static Image iconToImage(Icon icon) {
        return ResizingAdaptor.iconToImage(icon, new Dimension(icon.getIconWidth(), icon.getIconWidth()));
    }

    private static Image iconToImage(Icon icon, Dimension dimension) {
        if (icon instanceof ImageIcon) {
            return ((ImageIcon)icon).getImage();
        }
        int n = dimension.width;
        int n2 = dimension.height;
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice graphicsDevice = graphicsEnvironment.getDefaultScreenDevice();
        GraphicsConfiguration graphicsConfiguration = graphicsDevice.getDefaultConfiguration();
        BufferedImage bufferedImage = graphicsConfiguration.createCompatibleImage(n, n2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        icon.paintIcon(null, graphics2D, 0, 0);
        graphics2D.dispose();
        return bufferedImage;
    }

    private static void resizeImage(double d, Component component, int n, int n2, int n3) {
        Accessible accessible;
        Image image = null;
        if (component instanceof IconLabel) {
            accessible = (IconLabel)component;
            image = ResizingAdaptor.iconToImage(accessible.getOriginalIcon(), accessible.getOriginalDimension());
        } else {
            image = ResizingAdaptor.iconToImage(((JLabel)component).getIcon());
        }
        accessible = new ImageIcon(image.getScaledInstance((int)Math.round((double)(n * n3) * d), (int)Math.round((double)(n2 * n3) * d), 4));
        ((JLabel)component).setIcon((Icon)((Object)accessible));
    }

    private static final void resizeImageButton(double d, Component component) {
        JButton jButton = (JButton)component;
        ImageIcon imageIcon = null;
        double d2 = d;
        imageIcon = jButton.getName() != null && jButton.getName().equalsIgnoreCase("maximizar") ? Constants.IMAGEICON_MAXIMIZE : (jButton.getName() != null && jButton.getName().equalsIgnoreCase("restaurar") ? Constants.IMAGEICONRESTORE : new ImageIcon(ResizingAdaptor.iconToImage(jButton.getIcon())));
        int n = (int)Math.round(50.0 * d2);
        n = n < 25 ? 25 : n;
        ImageIcon imageIcon2 = new ImageIcon(imageIcon.getImage().getScaledInstance(n, n, 4));
        jButton.setIcon(imageIcon2);
        jButton.setPreferredSize(new Dimension(n, n));
    }

    private static float getFontSize() {
        if (GeneralConfig.isBigFontSize()) {
            return 16.0f;
        }
        return 14.0f;
    }

    private static boolean isResizable(Component component) {
        boolean bl = false;
        bl = bl || component instanceof JButton || component instanceof JLabel;
        bl = bl || component instanceof JTextField;
        bl = bl || component instanceof JPanel;
        return bl || component instanceof JCheckBox;
    }

    private static float getResizingFactorFrame() {
        return 3.0f;
    }

    private static float getResizingFactorFileChooser() {
        return 3.0f;
    }

    private static float getResizingFactorCustomDialog() {
        return 2.0f;
    }
}

