/*
 * Decompiled with CFR 0.152.
 */
package es.gob.jmulticard.ui.passwordcallback.gui;

import es.gob.jmulticard.ui.passwordcallback.CancelledOperationException;
import es.gob.jmulticard.ui.passwordcallback.Messages;
import es.gob.jmulticard.ui.passwordcallback.gui.GeneralConfig;
import es.gob.jmulticard.ui.passwordcallback.gui.IconLabel;
import es.gob.jmulticard.ui.passwordcallback.gui.InfoLabel;
import es.gob.jmulticard.ui.passwordcallback.gui.JAccessibilityCustomDialog;
import es.gob.jmulticard.ui.passwordcallback.gui.JSecurePasswordLabel;
import es.gob.jmulticard.ui.passwordcallback.gui.RequestFocusListener;
import es.gob.jmulticard.ui.passwordcallback.gui.Utils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JWindow;
import javax.swing.KeyStroke;

public final class CustomDialog
extends JAccessibilityCustomDialog
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private InfoLabel infoLabel = null;
    private JPanel buttonsPanel = null;
    private JPanel accessibilityButtonsPanel = null;
    private JPanel mainPanel = null;
    private JSecurePasswordLabel component = null;
    private final IconLabel iconLabel = new IconLabel();
    private static JButton okButton = null;
    private JButton noButton = null;
    private static JButton cancelButton = null;
    private JButton restoreButton = null;
    private JButton maximizeButton = null;
    private int answer;
    private static String cancellText = Messages.getString("PrincipalGUI.cancelar");

    JSecurePasswordLabel getComponent() {
        return this.component;
    }

    static JButton getOkButton() {
        return okButton;
    }

    JButton getNoButton() {
        return this.noButton;
    }

    static JButton getCancelButton() {
        return cancelButton;
    }

    JButton getRestoreButton() {
        return this.restoreButton;
    }

    JButton getMaximizeButton() {
        return this.maximizeButton;
    }

    private CustomDialog(JDialog jDialog, boolean bl, String string, String string2, int n, boolean bl2) {
        super(jDialog, bl, bl2);
        this.initComponents(string, string2, n, bl2);
        this.setLocationRelativeTo(jDialog);
        this.pack();
    }

    private CustomDialog(Component component, boolean bl, String string, String string2, int n, boolean bl2) {
        super(bl2);
        this.setModal(bl);
        this.initComponents(string, string2, n, bl2);
        this.setLocationRelativeTo(component);
        this.pack();
    }

    private CustomDialog(JFrame jFrame, boolean bl, String string, String string2, int n, boolean bl2) {
        super(jFrame, bl, bl2);
        this.initComponents(string, string2, n, bl2);
        this.setLocationRelativeTo(jFrame);
        this.pack();
    }

    private static int getInitialX(int n) {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        return dimension.width / 2 - n / 2;
    }

    private static int getInitialY(int n) {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        return dimension.height / 2 - n / 2;
    }

    private void initComponents(String string, String string2, int n, boolean bl) {
        int n2 = this.getMaxWidth();
        int n3 = this.getMaxHeight();
        this.setMinimumSize(new Dimension(this.getInitialWidth(), this.getInitialHeight()));
        this.setPreferredSize(new Dimension(this.getInitialWidth(), this.getInitialHeight()));
        this.setMaximumSize(new Dimension(n2, n3));
        if (GeneralConfig.isMaximized()) {
            this.setBounds(0, 0, n2, n3);
        } else if (GeneralConfig.isBigFontSize() || GeneralConfig.isFontBold()) {
            this.setMinimumSize(new Dimension(555, 250));
        }
        this.setTitle(string2);
        this.setDefaultCloseOperation(2);
        this.answer = 1;
        Container container = this.getContentPane();
        container.setLayout(new GridBagLayout());
        this.mainPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(5, 10, 0, 10);
        this.setIconLabel();
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.fill = 1;
        jPanel.add((Component)this.iconLabel, gridBagConstraints2);
        gridBagConstraints.insets = new Insets(10, 5, 0, 10);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        if (bl) {
            this.infoLabel = new InfoLabel(string);
            this.infoLabel.setHorizontalAlignment(2);
            this.infoLabel.setVerticalAlignment(0);
        } else {
            this.infoLabel = new InfoLabel(string, false);
            this.infoLabel.setHorizontalAlignment(0);
            this.infoLabel.addAncestorListener(new RequestFocusListener());
            this.infoLabel.setVerticalAlignment(0);
        }
        this.mainPanel.add((Component)this.infoLabel, gridBagConstraints);
        this.createMainButtonsPanel();
        this.createAccessibilityButtonsPanel();
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.fill = 1;
        gridBagConstraints3.gridx = 0;
        gridBagConstraints3.gridy = 0;
        gridBagConstraints3.gridwidth = 2;
        gridBagConstraints3.gridheight = 1;
        gridBagConstraints3.weighty = 0.0;
        gridBagConstraints3.weightx = 0.1;
        container.add((Component)this.accessibilityButtonsPanel, gridBagConstraints3);
        gridBagConstraints3.gridx = 2;
        gridBagConstraints3.gridy = 0;
        gridBagConstraints3.gridwidth = 6;
        gridBagConstraints3.gridheight = bl ? 2 : 3;
        gridBagConstraints3.weighty = bl ? 0.35 : 0.65;
        gridBagConstraints3.weightx = 0.9;
        container.add((Component)this.mainPanel, gridBagConstraints3);
        gridBagConstraints3.gridx = 0;
        gridBagConstraints3.gridy = 1;
        gridBagConstraints3.gridwidth = 2;
        gridBagConstraints3.gridheight = 3;
        gridBagConstraints3.weighty = 0.9;
        gridBagConstraints3.weightx = 0.0;
        container.add((Component)jPanel, gridBagConstraints3);
        gridBagConstraints3.gridx = 2;
        gridBagConstraints3.gridy = 3;
        gridBagConstraints3.gridwidth = 6;
        gridBagConstraints3.gridheight = 1;
        gridBagConstraints3.weighty = bl ? 0.65 : 0.35;
        gridBagConstraints3.weightx = 0.0;
        container.add((Component)this.buttonsPanel, gridBagConstraints3);
        this.pack();
    }

    private void setIconLabel() {
        ImageIcon imageIcon = new ImageIcon(CustomDialog.class.getResource("/images/dnie.png"));
        Dimension dimension = new Dimension(100, (int)(100.0f / (float)imageIcon.getIconWidth() * (float)imageIcon.getIconHeight()));
        this.iconLabel.setOriginalIcon(imageIcon);
        this.iconLabel.setOriginalDimension(dimension);
        imageIcon = new ImageIcon(imageIcon.getImage().getScaledInstance(dimension.width, dimension.height, 4));
        this.iconLabel.setIcon(imageIcon);
    }

    private void createAccessibilityButtonsPanel() {
        this.accessibilityButtonsPanel = new JPanel(new GridBagLayout());
        final JWindow jWindow = new JWindow();
        final JLabel jLabel = new JLabel();
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        JPanel jPanel2 = new JPanel();
        ImageIcon imageIcon = new ImageIcon(CustomDialog.class.getResource("/images/restore.png"));
        this.restoreButton = new JButton(imageIcon);
        this.restoreButton.setMnemonic(82);
        this.restoreButton.setToolTipText(Messages.getString("Wizard.restaurar.description"));
        this.restoreButton.getAccessibleContext().setAccessibleName(this.restoreButton.getToolTipText());
        this.restoreButton.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                Utils.showToolTip(false, jWindow, CustomDialog.this.getRestoreButton(), jLabel);
            }

            @Override
            public void focusGained(FocusEvent focusEvent) {
                Utils.showToolTip(true, jWindow, CustomDialog.this.getRestoreButton(), jLabel);
            }
        });
        Dimension dimension = new Dimension(20, 20);
        this.restoreButton.setPreferredSize(dimension);
        this.restoreButton.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
            }

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (10 == keyEvent.getKeyCode()) {
                    CustomDialog.this.getRestoreButton().doClick();
                }
            }
        });
        this.restoreButton.setName("restaurar");
        jPanel2.add(this.restoreButton);
        this.restoreButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CustomDialog.this.restaurarActionPerformed();
            }
        });
        Utils.remarcar(this.restoreButton);
        jPanel.add((Component)jPanel2, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        JPanel jPanel3 = new JPanel();
        ImageIcon imageIcon2 = new ImageIcon(CustomDialog.class.getResource("/images/maximize.png"));
        this.maximizeButton = new JButton(imageIcon2);
        this.maximizeButton.setMnemonic(77);
        this.maximizeButton.setToolTipText(Messages.getString("Wizard.maximizar.description"));
        this.maximizeButton.getAccessibleContext().setAccessibleName(this.maximizeButton.getToolTipText());
        this.maximizeButton.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
            }

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (10 == keyEvent.getKeyCode()) {
                    CustomDialog.this.getMaximizeButton().doClick();
                }
            }
        });
        this.maximizeButton.setName("maximizar");
        this.maximizeButton.setPreferredSize(dimension);
        Utils.remarcar(this.maximizeButton);
        jPanel3.add(this.maximizeButton);
        this.maximizeButton.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                Utils.showToolTip(false, jWindow, CustomDialog.this.getMaximizeButton(), jLabel);
            }

            @Override
            public void focusGained(FocusEvent focusEvent) {
                Utils.showToolTip(true, jWindow, CustomDialog.this.getMaximizeButton(), jLabel);
            }
        });
        this.maximizeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CustomDialog.this.maximizarActionPerformed();
            }
        });
        jPanel.add((Component)jPanel3, gridBagConstraints);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.fill = 0;
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.weighty = 1.0;
        gridBagConstraints2.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints2.anchor = 15;
        this.accessibilityButtonsPanel.add((Component)jPanel, gridBagConstraints2);
        if (GeneralConfig.isMaximized()) {
            this.maximizeButton.setEnabled(false);
            this.restoreButton.setEnabled(true);
        } else {
            this.maximizeButton.setEnabled(true);
            this.restoreButton.setEnabled(false);
        }
    }

    void createMainButtonsPanel() {
        this.buttonsPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 10, 0, 10);
        gridBagConstraints.anchor = 10;
        JPanel jPanel = new JPanel();
        okButton = this.getButton(Messages.getString("PrincipalGUI.aceptar"), 65);
        okButton.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
            }

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (10 == keyEvent.getKeyCode()) {
                    CustomDialog.getOkButton().doClick();
                }
            }
        });
        jPanel.add(okButton);
        this.buttonsPanel.add((Component)jPanel, gridBagConstraints);
        okButton.addActionListener(this);
    }

    public static int showConfirmDialog(Component component, boolean bl, String string, String string2, int n, int n2) {
        final CustomDialog customDialog = CustomDialog.getInstanceCustomDialog(component, bl, string, string2, n2, false);
        okButton.setEnabled(true);
        customDialog.getRootPane().setDefaultButton(null);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 10);
        if (n != 0) {
            throw new UnsupportedOperationException("Solo se soportan dialogos de tipo Si/No");
        }
        okButton.setText(Messages.getString("CustomDialog.confirmDialog.yes"));
        okButton.setMnemonic(83);
        customDialog.noButton = customDialog.getButton(Messages.getString("CustomDialog.confirmDialog.no"), 78);
        customDialog.noButton.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
            }

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (10 == keyEvent.getKeyCode()) {
                    customDialog.getNoButton().doClick();
                }
            }
        });
        JPanel jPanel = new JPanel();
        jPanel.add(customDialog.noButton);
        customDialog.buttonsPanel.add((Component)jPanel, gridBagConstraints);
        customDialog.noButton.addActionListener(customDialog);
        customDialog.infoLabel.setHorizontalAlignment(0);
        customDialog.pack();
        customDialog.setSize(customDialog.getInitialWidth() + 1, customDialog.getInitialHeight() + 1);
        customDialog.setVisible(true);
        return customDialog.getAnswer();
    }

    public static char[] showInputPasswordDialog(Component component, boolean bl, boolean bl2, String string, int n, String string2, int n2) {
        final CustomDialog customDialog = CustomDialog.getInstanceCustomDialog(component, bl, string, string2, n2, true);
        okButton.setEnabled(false);
        customDialog.getRootPane().setDefaultButton(null);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(2, 5, 2, 10);
        customDialog.component = new JSecurePasswordLabel(16);
        customDialog.component.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                int n = customDialog.getComponent().getPasswordLength();
                if (n > 7 && n < 17) {
                    CustomDialog.getOkButton().setEnabled(true);
                    if (10 == keyEvent.getKeyCode()) {
                        CustomDialog.getOkButton().doClick();
                    }
                } else {
                    CustomDialog.getOkButton().setEnabled(false);
                }
            }

            @Override
            public void keyPressed(KeyEvent keyEvent) {
            }
        });
        customDialog.component.addAncestorListener(new RequestFocusListener());
        Utils.remarcar(customDialog.component);
        Utils.setContrastColor(customDialog.component);
        Utils.setFontBold(customDialog.component);
        customDialog.component.getAccessibleContext().setAccessibleName(string.replaceAll("<br>", "") + "  ALT + " + n + ". ");
        customDialog.mainPanel.add((Component)customDialog.component, gridBagConstraints);
        customDialog.infoLabel.setLabelFor(customDialog.component);
        customDialog.infoLabel.setDisplayedMnemonic(n);
        String string3 = Utils.remarkMnemonic(customDialog.infoLabel.getText(), n);
        customDialog.infoLabel.setText(string3);
        gridBagConstraints.insets = new Insets(0, 0, 0, 10);
        gridBagConstraints.gridy = 2;
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.insets = new Insets(0, 0, 0, 10);
        cancelButton = customDialog.getButton(cancellText, 67);
        JPanel jPanel = new JPanel();
        jPanel.add(cancelButton);
        customDialog.buttonsPanel.add((Component)jPanel, gridBagConstraints2);
        cancelButton.addActionListener(customDialog);
        cancelButton.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
            }

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (10 == keyEvent.getKeyCode()) {
                    CustomDialog.getCancelButton().doClick();
                }
            }
        });
        customDialog.infoLabel.setHorizontalAlignment(2);
        customDialog.component.setVisible(true);
        cancelButton.addActionListener(customDialog);
        customDialog.pack();
        customDialog.setSize(customDialog.getInitialWidth() + 1, customDialog.getInitialHeight() + 1);
        customDialog.setVisible(true);
        if (customDialog.getAnswer() == 0) {
            char[] cArray = customDialog.getComponent().getPassword();
            customDialog.getComponent().setText("");
            customDialog.getComponent().setText(null);
            customDialog.component = null;
            customDialog.dispose();
            System.runFinalization();
            System.gc();
            return cArray;
        }
        throw new CancelledOperationException("La insercion de contrasena ha sido cancelada por el usuario");
    }

    private JButton getButton(String string, int n) {
        JButton jButton = new JButton(string);
        jButton.setMnemonic(n);
        Utils.remarcar(jButton);
        Utils.setContrastColor(jButton);
        Utils.setFontBold(jButton);
        if (string.equalsIgnoreCase(cancellText)) {
            this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), "cancel");
            this.getRootPane().getActionMap().put("cancel", new ButtonAbstractAction());
        }
        return jButton;
    }

    @Override
    public int getMinimumRelation() {
        return 7;
    }

    private int getAnswer() {
        return this.answer;
    }

    void maximizarActionPerformed() {
        CustomDialog.setActualPositionX(this.getX());
        CustomDialog.setActualPositionY(this.getY());
        CustomDialog.setActualWidth(this.getWidth());
        CustomDialog.setActualHeight(this.getHeight());
        int n = this.getMaxWidth();
        int n2 = this.getMaxHeight();
        this.setBounds(CustomDialog.getInitialX(n), CustomDialog.getInitialY(n2), n, n2);
        this.maximizeButton.setEnabled(false);
        this.restoreButton.setEnabled(true);
    }

    void restaurarActionPerformed() {
        int n = this.getInitialWidth();
        int n2 = this.getInitialHeight();
        if (GeneralConfig.isBigFontSize() || GeneralConfig.isFontBold() || this.isBigSizeDefault()) {
            n = 555;
            n2 = 250;
        }
        this.setMinimumSize(new Dimension(n, n2));
        if (CustomDialog.getActualPositionX() != -1 && CustomDialog.getActualPositionY() != -1 && CustomDialog.getActualWidth() != -1 && CustomDialog.getActualHeight() != -1) {
            this.setBounds(CustomDialog.getActualPositionX(), CustomDialog.getActualPositionY(), CustomDialog.getActualWidth(), CustomDialog.getActualHeight());
        } else {
            this.setBounds(CustomDialog.getInitialX(n), CustomDialog.getInitialY(n2), n, n2);
        }
        this.maximizeButton.setEnabled(true);
        this.restoreButton.setEnabled(false);
    }

    static CustomDialog getInstanceCustomDialog(Component component, boolean bl, String string, String string2, int n, boolean bl2) {
        CustomDialog customDialog = null;
        customDialog = component instanceof JDialog ? new CustomDialog((JDialog)component, bl, string, string2, n, bl2) : (component instanceof JFrame ? new CustomDialog((JFrame)component, bl, string, string2, n, bl2) : new CustomDialog(component, bl, string, string2, n, bl2));
        return customDialog;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.answer = actionEvent.getSource().equals(okButton) ? 0 : (actionEvent.getSource().equals(this.noButton) ? 1 : 2);
        this.setVisible(false);
    }

    private static final class ButtonAbstractAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        ButtonAbstractAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CustomDialog.getCancelButton().doClick();
        }
    }
}

