/*
 * Decompiled with CFR 0.152.
 */
package es.gob.jmulticard.ui.passwordcallback.gui;

import es.gob.jmulticard.ui.passwordcallback.CancelledOperationException;
import es.gob.jmulticard.ui.passwordcallback.Messages;
import es.gob.jmulticard.ui.passwordcallback.NoConsoleException;
import java.io.Console;
import javax.security.auth.callback.PasswordCallback;

final class ConsolePasswordCallback
extends PasswordCallback {
    private static final long serialVersionUID = -4044214967262414899L;
    private final String prompt;

    ConsolePasswordCallback(String string) {
        super(string, true);
        this.prompt = string;
    }

    private static String removeHTML(String string) {
        return string.replace("<br/>", "").replaceAll("&nbsp;", "");
    }

    @Override
    public char[] getPassword() {
        Console console = System.console();
        if (console == null) {
            throw new NoConsoleException("No hay consola para solicitar el PIN");
        }
        char[] cArray = console.readPassword(ConsolePasswordCallback.removeHTML(this.prompt) + ":\n", new Object[0]);
        if (cArray == null) {
            throw new CancelledOperationException("Se ha cancelado la introduccion de PIN en consola");
        }
        if (cArray.length < 8 || cArray.length > 16) {
            console.printf(Messages.getString("ConsolePasswordCallback.1") + "\n", new Object[0]);
            for (int i = 0; i < cArray.length; ++i) {
                cArray[i] = '\u0000';
            }
            return this.getPassword();
        }
        console.flush();
        console = null;
        return cArray;
    }
}

