/*
 * Decompiled with CFR 0.152.
 */
package es.gob.jmulticard.ui.passwordcallback.gui;

import es.gob.jmulticard.ui.passwordcallback.Messages;
import es.gob.jmulticard.ui.passwordcallback.PasswordCallbackManager;
import es.gob.jmulticard.ui.passwordcallback.gui.ConsolePasswordCallback;
import es.gob.jmulticard.ui.passwordcallback.gui.UIPasswordCallbackAccessibility;
import java.awt.HeadlessException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.logging.Logger;
import javax.security.auth.callback.PasswordCallback;

public final class CommonPasswordCallback
extends PasswordCallback {
    private static boolean headless = false;
    private static final long serialVersionUID = 5514503307266079255L;
    private final String title;

    static void setHeadLess(boolean bl) {
        headless = bl;
    }

    private CommonPasswordCallback(String string, String string2) {
        super(string, true);
        if (string == null) {
            throw new IllegalArgumentException("El texto de solicitud no puede ser nulo");
        }
        this.title = string2 == null ? string : string2;
    }

    @Override
    public char[] getPassword() {
        if (!headless) {
            try {
                UIPasswordCallbackAccessibility uIPasswordCallbackAccessibility = new UIPasswordCallbackAccessibility(this.getPrompt(), PasswordCallbackManager.getDialogOwner(), this.getPrompt(), 80, this.title);
                char[] cArray = uIPasswordCallbackAccessibility.getPassword();
                uIPasswordCallbackAccessibility.clearPassword();
                uIPasswordCallbackAccessibility = null;
                return cArray;
            }
            catch (HeadlessException headlessException) {
                Logger.getLogger("es.gob.jmulticard").info("No hay entorno grafico, se revierte a consola: " + headlessException);
            }
        }
        ConsolePasswordCallback consolePasswordCallback = new ConsolePasswordCallback(this.getPrompt());
        char[] cArray = consolePasswordCallback.getPassword();
        consolePasswordCallback.clearPassword();
        consolePasswordCallback = null;
        return cArray;
    }

    public static PasswordCallback getDnieBadPinPasswordCallback(int n) {
        return new CommonPasswordCallback(Messages.getString("CommonPasswordCallback.0") + " " + Integer.toString(n), Messages.getString("CommonPasswordCallback.1"));
    }

    public static PasswordCallback getDniePinForCertificateReadingPasswordCallback() {
        return new CommonPasswordCallback(Messages.getString("CommonPasswordCallback.4"), Messages.getString("CommonPasswordCallback.1"));
    }

    static {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                CommonPasswordCallback.setHeadLess(Boolean.getBoolean("java.awt.headless"));
                return null;
            }
        });
    }
}

