/*
 * Decompiled with CFR 0.152.
 */
package es.gob.jmulticard.ui.passwordcallback;

import es.gob.jmulticard.ui.passwordcallback.Messages;
import es.gob.jmulticard.ui.passwordcallback.NoConsoleException;
import es.gob.jmulticard.ui.passwordcallback.PasswordCallbackManager;
import es.gob.jmulticard.ui.passwordcallback.gui.CustomDialog;
import java.awt.Component;
import java.awt.HeadlessException;
import java.io.Console;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Locale;
import java.util.logging.Logger;

public final class DialogBuilder {
    private static boolean headless = false;

    static void setHeadLess(boolean bl) {
        headless = bl;
    }

    private DialogBuilder() {
    }

    public static int showSignatureConfirmDialog(Component component, boolean bl) {
        Console console;
        if (!headless) {
            try {
                return CustomDialog.showConfirmDialog(component != null ? component : PasswordCallbackManager.getDialogOwner(), true, bl ? Messages.getString("DialogBuilder.2") : Messages.getString("DialogBuilder.3"), Messages.getString("DialogBuilder.1"), 0, 2);
            }
            catch (HeadlessException headlessException) {
                Logger.getLogger("es.gob.jmulticard").info("No hay entorno grafico, se revierte a consola: " + headlessException);
            }
        }
        if ((console = System.console()) == null) {
            throw new NoConsoleException("No hay consola para solicitar el PIN");
        }
        return DialogBuilder.getConsoleConfirm(console, bl);
    }

    private static int getConsoleConfirm(Console console, boolean bl) {
        console.printf((bl ? Messages.getString("DialogBuilder.2") : Messages.getString("DialogBuilder.3")) + " " + Messages.getString("DialogBuilder.4") + "\n", new Object[0]);
        String string = console.readLine().replace("\n", "").replace("\r", "").trim().toLowerCase(Locale.getDefault());
        if ("si".equals(string) || "s".equals(string) || "s\u00ed".equals(string)) {
            return 0;
        }
        if ("no".equals(string) || "n".equals(string)) {
            return 1;
        }
        return DialogBuilder.getConsoleConfirm(console, bl);
    }

    static {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                DialogBuilder.setHeadLess(Boolean.getBoolean("java.awt.headless"));
                return null;
            }
        });
    }
}

