/*
 * Decompiled with CFR 0.152.
 */
package es.gob.jmulticard.jse.smartcardio;

import es.gob.jmulticard.HexUtils;
import es.gob.jmulticard.apdu.CommandApdu;
import es.gob.jmulticard.apdu.ResponseApdu;
import es.gob.jmulticard.apdu.connection.ApduConnection;
import es.gob.jmulticard.apdu.connection.ApduConnectionException;
import es.gob.jmulticard.apdu.connection.ApduConnectionOpenedInExclusiveModeException;
import es.gob.jmulticard.apdu.connection.CardConnectionListener;
import es.gob.jmulticard.apdu.connection.CardNotPresentException;
import es.gob.jmulticard.apdu.connection.LostChannelException;
import es.gob.jmulticard.apdu.connection.NoReadersFoundException;
import es.gob.jmulticard.apdu.iso7816four.GetResponseApduCommand;
import java.util.List;
import java.util.logging.Logger;
import javax.smartcardio.Card;
import javax.smartcardio.CardChannel;
import javax.smartcardio.CardException;
import javax.smartcardio.CardTerminal;
import javax.smartcardio.CommandAPDU;
import javax.smartcardio.TerminalFactory;

public final class SmartcardIoConnection
implements ApduConnection {
    private static final boolean DEBUG = false;
    private static final String SCARD_W_RESET_CARD = "SCARD_W_RESET_CARD";
    private static final Logger LOGGER = Logger.getLogger("es.gob.jmulticard");
    private int terminalNumber = 0;
    private CardChannel canal = null;
    private Card card = null;
    private boolean exclusive = false;
    private ConnectionProtocol protocol = ConnectionProtocol.T0;
    private static final byte TAG_RESPONSE_PENDING = 97;
    private static final byte TAG_RESPONSE_INVALID_LENGTH = 108;

    @Override
    public void addCardConnectionListener(CardConnectionListener cardConnectionListener) {
        throw new UnsupportedOperationException("JSR-268 no soporta eventos de insercion o extraccion");
    }

    @Override
    public void close() throws ApduConnectionException {
        if (this.card != null) {
            try {
                this.card.disconnect(false);
            }
            catch (Exception exception) {
                throw new ApduConnectionException("Error intentando cerrar el objeto de tarjeta inteligente, la conexion puede quedar abierta pero inutil", exception);
            }
            this.card = null;
        }
        this.canal = null;
    }

    @Override
    public String getTerminalInfo(int n) throws ApduConnectionException {
        try {
            CardTerminal cardTerminal;
            List<CardTerminal> list = TerminalFactory.getDefault().terminals().list();
            if (n < list.size() && (cardTerminal = list.get(n)) != null) {
                return cardTerminal.getName();
            }
            return null;
        }
        catch (Exception exception) {
            throw new ApduConnectionException("Error recuperando la lista de lectores de tarjetas del sistema", exception);
        }
    }

    @Override
    public long[] getTerminals(boolean bl) throws ApduConnectionException {
        List<CardTerminal> list;
        try {
            list = TerminalFactory.getDefault().terminals().list();
        }
        catch (CardException cardException) {
            LOGGER.warning("No se ha podido recuperar la lista de lectores del sistema: " + cardException);
            return new long[0];
        }
        try {
            if (list.size() > 0) {
                int n = 0;
                if (bl) {
                    for (CardTerminal cardTerminal : list) {
                        if (!cardTerminal.isCardPresent()) continue;
                        ++n;
                    }
                } else {
                    n = list.size();
                }
                Object object = new long[n];
                int n2 = 0;
                for (int i = 0; i < list.size(); ++i) {
                    CardTerminal cardTerminal = list.get(i);
                    if (bl) {
                        if (!cardTerminal.isCardPresent()) continue;
                        object[n2] = (long)i;
                    } else {
                        object[n2] = (long)i;
                    }
                    ++n2;
                }
                return object;
            }
            return new long[0];
        }
        catch (Exception exception) {
            throw new ApduConnectionException("Error recuperando la lista de lectores de tarjetas del sistema", exception);
        }
    }

    @Override
    public boolean isOpen() {
        return this.card != null;
    }

    @Override
    public void open() throws ApduConnectionException {
        System.setProperty("sun.security.smartcardio.t0GetResponse", "false");
        System.setProperty("sun.security.smartcardio.t1GetResponse", "false");
        if (this.isExclusiveUse() && this.isOpen()) {
            throw new ApduConnectionOpenedInExclusiveModeException();
        }
        try {
            List<CardTerminal> list = TerminalFactory.getDefault().terminals().list();
            if (list.size() < 1) {
                throw new NoReadersFoundException();
            }
            if (list.size() <= this.terminalNumber) {
                throw new ApduConnectionException("No se detecto el lector de tarjetas numero " + Integer.toString(this.terminalNumber));
            }
            this.card = list.get(this.terminalNumber).connect(this.protocol.toString());
        }
        catch (javax.smartcardio.CardNotPresentException cardNotPresentException) {
            throw new CardNotPresentException(cardNotPresentException);
        }
        catch (CardException cardException) {
            throw new ApduConnectionException("No se ha podido abrir la conexion con el lector de tarjetas numero " + Integer.toString(this.terminalNumber), cardException);
        }
        if (this.exclusive) {
            try {
                this.card.beginExclusive();
            }
            catch (CardException cardException) {
                throw new ApduConnectionException("No se ha podido abrir la conexion exclusiva con el lector de tarjetas numero " + Integer.toString(this.terminalNumber), cardException);
            }
        }
        this.canal = this.card.getBasicChannel();
    }

    @Override
    public void removeCardConnectionListener(CardConnectionListener cardConnectionListener) {
        throw new UnsupportedOperationException("JSR-268 no soporta eventos de insercion o extraccion");
    }

    @Override
    public byte[] reset() throws ApduConnectionException {
        this.close();
        this.open();
        if (this.card != null) {
            return this.card.getATR().getBytes();
        }
        throw new ApduConnectionException("Error indefinido reiniciando la conexion con la tarjeta");
    }

    public void setExclusiveUse(boolean bl) {
        if (this.card == null) {
            this.exclusive = bl;
        } else {
            LOGGER.warning("No se puede cambiar el modo de acceso a la tarjeta con la conexion abierta, se mantendra el modo EXCLUSIVE=" + Boolean.toString(this.exclusive));
        }
    }

    public void setProtocol(ConnectionProtocol connectionProtocol) {
        if (connectionProtocol == null) {
            LOGGER.warning("El protocolo de conexion no puede ser nulo, se usara T=0");
            this.protocol = ConnectionProtocol.T0;
            return;
        }
        this.protocol = connectionProtocol;
    }

    @Override
    public void setTerminal(int n) {
        if (this.terminalNumber == n) {
            return;
        }
        boolean bl = this.isOpen();
        if (bl) {
            try {
                this.close();
            }
            catch (Exception exception) {
                LOGGER.warning("Error intentando cerrar la conexion con el lector: " + exception);
            }
            this.terminalNumber = n;
            if (bl) {
                try {
                    this.open();
                }
                catch (Exception exception) {
                    LOGGER.warning("Error intentando abrir la conexion con el lector: " + exception);
                }
            }
        }
    }

    @Override
    public ResponseApdu transmit(CommandApdu commandApdu) throws ApduConnectionException {
        if (this.canal == null) {
            throw new ApduConnectionException("No se puede transmitir sobre una conexion cerrada");
        }
        if (commandApdu == null) {
            throw new IllegalArgumentException("No se puede transmitir una APDU nula");
        }
        try {
            ResponseApdu responseApdu = new ResponseApdu(this.canal.transmit(new CommandAPDU(commandApdu.getBytes())).getBytes());
            if (responseApdu.getStatusWord().getMsb() == 97) {
                if (responseApdu.getData().length > 0) {
                    byte[] byArray = responseApdu.getData();
                    byte[] byArray2 = this.transmit(new GetResponseApduCommand(0, responseApdu.getStatusWord().getLsb())).getBytes();
                    byte[] byArray3 = new byte[byArray.length + byArray2.length];
                    System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
                    System.arraycopy(byArray2, 0, byArray3, byArray.length, byArray2.length);
                    return new ResponseApdu(byArray3);
                }
                return this.transmit(new GetResponseApduCommand(0, responseApdu.getStatusWord().getLsb()));
            }
            if (responseApdu.getStatusWord().getMsb() == 108 && commandApdu.getCla() == 0) {
                commandApdu.setLe(responseApdu.getStatusWord().getLsb());
                return this.transmit(commandApdu);
            }
            return responseApdu;
        }
        catch (CardException cardException) {
            Throwable throwable = cardException.getCause();
            if (throwable != null && SCARD_W_RESET_CARD.equals(throwable.getMessage())) {
                throw new LostChannelException(throwable.getMessage());
            }
            throw new ApduConnectionException("Error de comunicacion con la tarjeta tratando de transmitir la APDU " + HexUtils.hexify(commandApdu.getBytes(), true) + " al lector " + Integer.toString(this.terminalNumber) + " en modo EXCLUSIVE=" + Boolean.toString(this.exclusive) + " con el protocolo " + this.protocol.toString(), cardException);
        }
        catch (Exception exception) {
            throw new ApduConnectionException("Error tratando de transmitir la APDU " + HexUtils.hexify(commandApdu.getBytes(), true) + " al lector " + Integer.toString(this.terminalNumber) + " en modo EXCLUSIVE=" + Boolean.toString(this.exclusive) + " con el protocolo " + this.protocol.toString(), exception);
        }
    }

    public ConnectionProtocol getProtocol() {
        return this.protocol;
    }

    public boolean isExclusiveUse() {
        return this.exclusive;
    }

    public static enum ConnectionProtocol {
        T0,
        T1,
        TCL;


        public String toString() {
            switch (this) {
                case T0: {
                    return "T=0";
                }
                case T1: {
                    return "T=1";
                }
                case TCL: {
                    return "T=CL";
                }
            }
            return "";
        }
    }
}

