/*
 * Decompiled with CFR 0.152.
 */
package es.gob.jmulticard.jse.provider.digest;

import es.gob.jmulticard.jse.provider.digest.LongDigest;
import es.gob.jmulticard.jse.provider.digest.Pack;

public final class SHA512Digest
extends LongDigest {
    private static final int DIGEST_LENGTH = 64;

    public SHA512Digest() {
        this.reset();
    }

    @Override
    public int getDigestSize() {
        return 64;
    }

    @Override
    public int doFinal(byte[] byArray, int n) {
        this.finish();
        Pack.longToBigEndian(this.h1Value, byArray, n);
        Pack.longToBigEndian(this.h2Value, byArray, n + 8);
        Pack.longToBigEndian(this.h3Value, byArray, n + 16);
        Pack.longToBigEndian(this.h4Value, byArray, n + 24);
        Pack.longToBigEndian(this.h5Value, byArray, n + 32);
        Pack.longToBigEndian(this.h6Value, byArray, n + 40);
        Pack.longToBigEndian(this.h7Value, byArray, n + 48);
        Pack.longToBigEndian(this.h8Value, byArray, n + 56);
        this.reset();
        return 64;
    }

    @Override
    public void reset() {
        super.reset();
        this.h1Value = 7640891576956012808L;
        this.h2Value = -4942790177534073029L;
        this.h3Value = 4354685564936845355L;
        this.h4Value = -6534734903238641935L;
        this.h5Value = 5840696475078001361L;
        this.h6Value = -7276294671716946913L;
        this.h7Value = 2270897969802886507L;
        this.h8Value = 6620516959819538809L;
    }
}

