/*
 * Decompiled with CFR 0.152.
 */
package es.gob.jmulticard.jse.provider.digest;

import es.gob.jmulticard.jse.provider.digest.LongDigest;
import es.gob.jmulticard.jse.provider.digest.Pack;

public final class SHA384Digest
extends LongDigest {
    private static final int DIGEST_LENGTH = 48;

    public SHA384Digest() {
        this.reset();
    }

    @Override
    public int getDigestSize() {
        return 48;
    }

    @Override
    public int doFinal(byte[] byArray, int n) {
        this.finish();
        Pack.longToBigEndian(this.h1Value, byArray, n);
        Pack.longToBigEndian(this.h2Value, byArray, n + 8);
        Pack.longToBigEndian(this.h3Value, byArray, n + 16);
        Pack.longToBigEndian(this.h4Value, byArray, n + 24);
        Pack.longToBigEndian(this.h5Value, byArray, n + 32);
        Pack.longToBigEndian(this.h6Value, byArray, n + 40);
        this.reset();
        return 48;
    }

    @Override
    public void reset() {
        super.reset();
        this.h1Value = -3766243637369397544L;
        this.h2Value = 7105036623409894663L;
        this.h3Value = -7973340178411365097L;
        this.h4Value = 1526699215303891257L;
        this.h5Value = 7436329637833083697L;
        this.h6Value = -8163818279084223215L;
        this.h7Value = -2662702644619276377L;
        this.h8Value = 5167115440072839076L;
    }
}

