/*
 * Decompiled with CFR 0.152.
 */
package es.gob.jmulticard.jse.provider.digest;

import es.gob.jmulticard.jse.provider.digest.GeneralDigest;
import es.gob.jmulticard.jse.provider.digest.Pack;

public final class SHA256Digest
extends GeneralDigest {
    private static final int DIGEST_LENGTH = 32;
    private int h1Value;
    private int h2Value;
    private int h3Value;
    private int h4Value;
    private int h5Value;
    private int h6Value;
    private int h7Value;
    private int h8Value;
    private final int[] xValue = new int[64];
    private int xOff;
    private static final int[] K_VALUE = new int[]{1116352408, 1899447441, -1245643825, -373957723, 961987163, 1508970993, -1841331548, -1424204075, -670586216, 310598401, 607225278, 1426881987, 1925078388, -2132889090, -1680079193, -1046744716, -459576895, -272742522, 264347078, 604807628, 770255983, 1249150122, 1555081692, 1996064986, -1740746414, -1473132947, -1341970488, -1084653625, -958395405, -710438585, 113926993, 338241895, 666307205, 773529912, 1294757372, 1396182291, 1695183700, 1986661051, -2117940946, -1838011259, -1564481375, -1474664885, -1035236496, -949202525, -778901479, -694614492, -200395387, 275423344, 430227734, 506948616, 659060556, 883997877, 958139571, 1322822218, 1537002063, 1747873779, 1955562222, 2024104815, -2067236844, -1933114872, -1866530822, -1538233109, -1090935817, -965641998};

    public SHA256Digest() {
        this.reset();
    }

    @Override
    public int getDigestSize() {
        return 32;
    }

    @Override
    protected void processWord(byte[] byArray, int n) {
        int n2 = n;
        int n3 = byArray[n2] << 24;
        n3 |= (byArray[++n2] & 0xFF) << 16;
        n3 |= (byArray[++n2] & 0xFF) << 8;
        this.xValue[this.xOff] = n3 |= byArray[++n2] & 0xFF;
        if (++this.xOff == 16) {
            this.processBlock();
        }
    }

    @Override
    protected void processLength(long l) {
        if (this.xOff > 14) {
            this.processBlock();
        }
        this.xValue[14] = (int)(l >>> 32);
        this.xValue[15] = (int)(l & 0xFFFFFFFFFFFFFFFFL);
    }

    @Override
    public int doFinal(byte[] byArray, int n) {
        this.finish();
        Pack.intToBigEndian(this.h1Value, byArray, n);
        Pack.intToBigEndian(this.h2Value, byArray, n + 4);
        Pack.intToBigEndian(this.h3Value, byArray, n + 8);
        Pack.intToBigEndian(this.h4Value, byArray, n + 12);
        Pack.intToBigEndian(this.h5Value, byArray, n + 16);
        Pack.intToBigEndian(this.h6Value, byArray, n + 20);
        Pack.intToBigEndian(this.h7Value, byArray, n + 24);
        Pack.intToBigEndian(this.h8Value, byArray, n + 28);
        this.reset();
        return 32;
    }

    @Override
    public void reset() {
        super.reset();
        this.h1Value = 1779033703;
        this.h2Value = -1150833019;
        this.h3Value = 1013904242;
        this.h4Value = -1521486534;
        this.h5Value = 1359893119;
        this.h6Value = -1694144372;
        this.h7Value = 528734635;
        this.h8Value = 1541459225;
        this.xOff = 0;
        for (int i = 0; i != this.xValue.length; ++i) {
            this.xValue[i] = 0;
        }
    }

    @Override
    protected void processBlock() {
        int n;
        int n2;
        for (n2 = 16; n2 <= 63; ++n2) {
            this.xValue[n2] = SHA256Digest.theta1(this.xValue[n2 - 2]) + this.xValue[n2 - 7] + SHA256Digest.theta0(this.xValue[n2 - 15]) + this.xValue[n2 - 16];
        }
        n2 = this.h1Value;
        int n3 = this.h2Value;
        int n4 = this.h3Value;
        int n5 = this.h4Value;
        int n6 = this.h5Value;
        int n7 = this.h6Value;
        int n8 = this.h7Value;
        int n9 = this.h8Value;
        int n10 = 0;
        for (n = 0; n < 8; ++n) {
            n5 += (n9 += SHA256Digest.sum1(n6) + SHA256Digest.ch(n6, n7, n8) + K_VALUE[n10] + this.xValue[n10]);
            n9 += SHA256Digest.sum0(n2) + SHA256Digest.maj(n2, n3, n4);
            n4 += (n8 += SHA256Digest.sum1(n5) + SHA256Digest.ch(n5, n6, n7) + K_VALUE[++n10] + this.xValue[n10]);
            n8 += SHA256Digest.sum0(n9) + SHA256Digest.maj(n9, n2, n3);
            n3 += (n7 += SHA256Digest.sum1(n4) + SHA256Digest.ch(n4, n5, n6) + K_VALUE[++n10] + this.xValue[n10]);
            n7 += SHA256Digest.sum0(n8) + SHA256Digest.maj(n8, n9, n2);
            n2 += (n6 += SHA256Digest.sum1(n3) + SHA256Digest.ch(n3, n4, n5) + K_VALUE[++n10] + this.xValue[n10]);
            n6 += SHA256Digest.sum0(n7) + SHA256Digest.maj(n7, n8, n9);
            n9 += (n5 += SHA256Digest.sum1(n2) + SHA256Digest.ch(n2, n3, n4) + K_VALUE[++n10] + this.xValue[n10]);
            n5 += SHA256Digest.sum0(n6) + SHA256Digest.maj(n6, n7, n8);
            n8 += (n4 += SHA256Digest.sum1(n9) + SHA256Digest.ch(n9, n2, n3) + K_VALUE[++n10] + this.xValue[n10]);
            n4 += SHA256Digest.sum0(n5) + SHA256Digest.maj(n5, n6, n7);
            n7 += (n3 += SHA256Digest.sum1(n8) + SHA256Digest.ch(n8, n9, n2) + K_VALUE[++n10] + this.xValue[n10]);
            n3 += SHA256Digest.sum0(n4) + SHA256Digest.maj(n4, n5, n6);
            n6 += (n2 += SHA256Digest.sum1(n7) + SHA256Digest.ch(n7, n8, n9) + K_VALUE[++n10] + this.xValue[n10]);
            n2 += SHA256Digest.sum0(n3) + SHA256Digest.maj(n3, n4, n5);
            ++n10;
        }
        this.h1Value += n2;
        this.h2Value += n3;
        this.h3Value += n4;
        this.h4Value += n5;
        this.h5Value += n6;
        this.h6Value += n7;
        this.h7Value += n8;
        this.h8Value += n9;
        this.xOff = 0;
        for (n = 0; n < 16; ++n) {
            this.xValue[n] = 0;
        }
    }

    private static int ch(int n, int n2, int n3) {
        return n & n2 ^ ~n & n3;
    }

    private static int maj(int n, int n2, int n3) {
        return n & n2 ^ n & n3 ^ n2 & n3;
    }

    private static int sum0(int n) {
        return (n >>> 2 | n << 30) ^ (n >>> 13 | n << 19) ^ (n >>> 22 | n << 10);
    }

    private static int sum1(int n) {
        return (n >>> 6 | n << 26) ^ (n >>> 11 | n << 21) ^ (n >>> 25 | n << 7);
    }

    private static int theta0(int n) {
        return (n >>> 7 | n << 25) ^ (n >>> 18 | n << 14) ^ n >>> 3;
    }

    private static int theta1(int n) {
        return (n >>> 17 | n << 15) ^ (n >>> 19 | n << 13) ^ n >>> 10;
    }
}

