/*
 * Decompiled with CFR 0.152.
 */
package es.gob.jmulticard.jse.provider.digest;

import es.gob.jmulticard.jse.provider.digest.GeneralDigest;
import es.gob.jmulticard.jse.provider.digest.Pack;

public final class SHA1Digest
extends GeneralDigest {
    private static final int DIGEST_LENGTH = 20;
    private int h1Value;
    private int h2Value;
    private int h3Value;
    private int h4Value;
    private int h5Value;
    private final int[] xValue = new int[80];
    private int xOff;
    private static final int Y1_VALUE = 1518500249;
    private static final int Y2_VALUE = 1859775393;
    private static final int Y3_VALUE = -1894007588;
    private static final int Y4_VALUE = -899497514;

    public SHA1Digest() {
        this.reset();
    }

    @Override
    public int getDigestSize() {
        return 20;
    }

    @Override
    protected void processWord(byte[] byArray, int n) {
        int n2 = n;
        int n3 = byArray[n2] << 24;
        n3 |= (byArray[++n2] & 0xFF) << 16;
        n3 |= (byArray[++n2] & 0xFF) << 8;
        this.xValue[this.xOff] = n3 |= byArray[++n2] & 0xFF;
        if (++this.xOff == 16) {
            this.processBlock();
        }
    }

    @Override
    protected void processLength(long l) {
        if (this.xOff > 14) {
            this.processBlock();
        }
        this.xValue[14] = (int)(l >>> 32);
        this.xValue[15] = (int)(l & 0xFFFFFFFFFFFFFFFFL);
    }

    @Override
    public int doFinal(byte[] byArray, int n) {
        this.finish();
        Pack.intToBigEndian(this.h1Value, byArray, n);
        Pack.intToBigEndian(this.h2Value, byArray, n + 4);
        Pack.intToBigEndian(this.h3Value, byArray, n + 8);
        Pack.intToBigEndian(this.h4Value, byArray, n + 12);
        Pack.intToBigEndian(this.h5Value, byArray, n + 16);
        this.reset();
        return 20;
    }

    @Override
    public void reset() {
        super.reset();
        this.h1Value = 1732584193;
        this.h2Value = -271733879;
        this.h3Value = -1732584194;
        this.h4Value = 271733878;
        this.h5Value = -1009589776;
        this.xOff = 0;
        for (int i = 0; i != this.xValue.length; ++i) {
            this.xValue[i] = 0;
        }
    }

    private static int fFunc(int n, int n2, int n3) {
        return n & n2 | ~n & n3;
    }

    private static int hFunc(int n, int n2, int n3) {
        return n ^ n2 ^ n3;
    }

    private static int gFunc(int n, int n2, int n3) {
        return n & n2 | n & n3 | n2 & n3;
    }

    @Override
    protected void processBlock() {
        int n;
        int n2;
        int n3;
        for (n3 = 16; n3 < 80; ++n3) {
            n2 = this.xValue[n3 - 3] ^ this.xValue[n3 - 8] ^ this.xValue[n3 - 14] ^ this.xValue[n3 - 16];
            this.xValue[n3] = n2 << 1 | n2 >>> 31;
        }
        n3 = this.h1Value;
        n2 = this.h2Value;
        int n4 = this.h3Value;
        int n5 = this.h4Value;
        int n6 = this.h5Value;
        int n7 = 0;
        for (n = 0; n < 4; ++n) {
            n6 += (n3 << 5 | n3 >>> 27) + SHA1Digest.fFunc(n2, n4, n5) + this.xValue[n7++] + 1518500249;
            n2 = n2 << 30 | n2 >>> 2;
            n5 += (n6 << 5 | n6 >>> 27) + SHA1Digest.fFunc(n3, n2, n4) + this.xValue[n7++] + 1518500249;
            n3 = n3 << 30 | n3 >>> 2;
            n4 += (n5 << 5 | n5 >>> 27) + SHA1Digest.fFunc(n6, n3, n2) + this.xValue[n7++] + 1518500249;
            n6 = n6 << 30 | n6 >>> 2;
            n2 += (n4 << 5 | n4 >>> 27) + SHA1Digest.fFunc(n5, n6, n3) + this.xValue[n7++] + 1518500249;
            n5 = n5 << 30 | n5 >>> 2;
            n3 += (n2 << 5 | n2 >>> 27) + SHA1Digest.fFunc(n4, n5, n6) + this.xValue[n7++] + 1518500249;
            n4 = n4 << 30 | n4 >>> 2;
        }
        for (n = 0; n < 4; ++n) {
            n6 += (n3 << 5 | n3 >>> 27) + SHA1Digest.hFunc(n2, n4, n5) + this.xValue[n7++] + 1859775393;
            n2 = n2 << 30 | n2 >>> 2;
            n5 += (n6 << 5 | n6 >>> 27) + SHA1Digest.hFunc(n3, n2, n4) + this.xValue[n7++] + 1859775393;
            n3 = n3 << 30 | n3 >>> 2;
            n4 += (n5 << 5 | n5 >>> 27) + SHA1Digest.hFunc(n6, n3, n2) + this.xValue[n7++] + 1859775393;
            n6 = n6 << 30 | n6 >>> 2;
            n2 += (n4 << 5 | n4 >>> 27) + SHA1Digest.hFunc(n5, n6, n3) + this.xValue[n7++] + 1859775393;
            n5 = n5 << 30 | n5 >>> 2;
            n3 += (n2 << 5 | n2 >>> 27) + SHA1Digest.hFunc(n4, n5, n6) + this.xValue[n7++] + 1859775393;
            n4 = n4 << 30 | n4 >>> 2;
        }
        for (n = 0; n < 4; ++n) {
            n6 += (n3 << 5 | n3 >>> 27) + SHA1Digest.gFunc(n2, n4, n5) + this.xValue[n7++] + -1894007588;
            n2 = n2 << 30 | n2 >>> 2;
            n5 += (n6 << 5 | n6 >>> 27) + SHA1Digest.gFunc(n3, n2, n4) + this.xValue[n7++] + -1894007588;
            n3 = n3 << 30 | n3 >>> 2;
            n4 += (n5 << 5 | n5 >>> 27) + SHA1Digest.gFunc(n6, n3, n2) + this.xValue[n7++] + -1894007588;
            n6 = n6 << 30 | n6 >>> 2;
            n2 += (n4 << 5 | n4 >>> 27) + SHA1Digest.gFunc(n5, n6, n3) + this.xValue[n7++] + -1894007588;
            n5 = n5 << 30 | n5 >>> 2;
            n3 += (n2 << 5 | n2 >>> 27) + SHA1Digest.gFunc(n4, n5, n6) + this.xValue[n7++] + -1894007588;
            n4 = n4 << 30 | n4 >>> 2;
        }
        for (n = 0; n <= 3; ++n) {
            n6 += (n3 << 5 | n3 >>> 27) + SHA1Digest.hFunc(n2, n4, n5) + this.xValue[n7++] + -899497514;
            n2 = n2 << 30 | n2 >>> 2;
            n5 += (n6 << 5 | n6 >>> 27) + SHA1Digest.hFunc(n3, n2, n4) + this.xValue[n7++] + -899497514;
            n3 = n3 << 30 | n3 >>> 2;
            n4 += (n5 << 5 | n5 >>> 27) + SHA1Digest.hFunc(n6, n3, n2) + this.xValue[n7++] + -899497514;
            n6 = n6 << 30 | n6 >>> 2;
            n2 += (n4 << 5 | n4 >>> 27) + SHA1Digest.hFunc(n5, n6, n3) + this.xValue[n7++] + -899497514;
            n5 = n5 << 30 | n5 >>> 2;
            n3 += (n2 << 5 | n2 >>> 27) + SHA1Digest.hFunc(n4, n5, n6) + this.xValue[n7++] + -899497514;
            n4 = n4 << 30 | n4 >>> 2;
        }
        this.h1Value += n3;
        this.h2Value += n2;
        this.h3Value += n4;
        this.h4Value += n5;
        this.h5Value += n6;
        this.xOff = 0;
        for (n = 0; n < 16; ++n) {
            this.xValue[n] = 0;
        }
    }
}

