/*
 * Decompiled with CFR 0.152.
 */
package es.gob.jmulticard.jse.provider.digest;

import es.gob.jmulticard.jse.provider.digest.ExtendedDigest;
import es.gob.jmulticard.jse.provider.digest.Pack;

abstract class LongDigest
implements ExtendedDigest {
    private static final int BYTE_LENGTH = 128;
    private final byte[] xBuf;
    private int xBufOff;
    private long byteCount1;
    private long byteCount2;
    protected long h1Value;
    protected long h2Value;
    protected long h3Value;
    protected long h4Value;
    protected long h5Value;
    protected long h6Value;
    protected long h7Value;
    protected long h8Value;
    private final long[] wValue = new long[80];
    private int wOff;
    private static final long[] K_VALUE = new long[]{4794697086780616226L, 8158064640168781261L, -5349999486874862801L, -1606136188198331460L, 4131703408338449720L, 6480981068601479193L, -7908458776815382629L, -6116909921290321640L, -2880145864133508542L, 1334009975649890238L, 2608012711638119052L, 6128411473006802146L, 8268148722764581231L, -9160688886553864527L, -7215885187991268811L, -4495734319001033068L, -1973867731355612462L, -1171420211273849373L, 1135362057144423861L, 2597628984639134821L, 3308224258029322869L, 5365058923640841347L, 6679025012923562964L, 8573033837759648693L, -7476448914759557205L, -6327057829258317296L, -5763719355590565569L, -4658551843659510044L, -4116276920077217854L, -3051310485924567259L, 489312712824947311L, 1452737877330783856L, 2861767655752347644L, 3322285676063803686L, 5560940570517711597L, 5996557281743188959L, 7280758554555802590L, 8532644243296465576L, -9096487096722542874L, -7894198246740708037L, -6719396339535248540L, -6333637450476146687L, -4446306890439682159L, -4076793802049405392L, -3345356375505022440L, -2983346525034927856L, -860691631967231958L, 1182934255886127544L, 1847814050463011016L, 2177327727835720531L, 2830643537854262169L, 3796741975233480872L, 4115178125766777443L, 5681478168544905931L, 6601373596472566643L, 7507060721942968483L, 8399075790359081724L, 8693463985226723168L, -8878714635349349518L, -8302665154208450068L, -8016688836872298968L, -6606660893046293015L, -4685533653050689259L, -4147400797238176981L, -3880063495543823972L, -3348786107499101689L, -1523767162380948706L, -757361751448694408L, 500013540394364858L, 748580250866718886L, 1242879168328830382L, 1977374033974150939L, 2944078676154940804L, 3659926193048069267L, 4368137639120453308L, 4836135668995329356L, 5532061633213252278L, 6448918945643986474L, 6902733635092675308L, 7801388544844847127L};

    protected LongDigest() {
        this.xBuf = new byte[8];
        this.xBufOff = 0;
        this.reset();
    }

    protected LongDigest(LongDigest longDigest) {
        this.xBuf = new byte[longDigest.xBuf.length];
        System.arraycopy(longDigest.xBuf, 0, this.xBuf, 0, longDigest.xBuf.length);
        this.xBufOff = longDigest.xBufOff;
        this.byteCount1 = longDigest.byteCount1;
        this.byteCount2 = longDigest.byteCount2;
        this.h1Value = longDigest.h1Value;
        this.h2Value = longDigest.h2Value;
        this.h3Value = longDigest.h3Value;
        this.h4Value = longDigest.h4Value;
        this.h5Value = longDigest.h5Value;
        this.h6Value = longDigest.h6Value;
        this.h7Value = longDigest.h7Value;
        this.h8Value = longDigest.h8Value;
        System.arraycopy(longDigest.wValue, 0, this.wValue, 0, longDigest.wValue.length);
        this.wOff = longDigest.wOff;
    }

    @Override
    public void update(byte by) {
        this.xBuf[this.xBufOff++] = by;
        if (this.xBufOff == this.xBuf.length) {
            this.processWord(this.xBuf, 0);
            this.xBufOff = 0;
        }
        ++this.byteCount1;
    }

    @Override
    public void update(byte[] byArray, int n, int n2) {
        int n3;
        int n4 = n;
        for (n3 = n2; this.xBufOff != 0 && n3 > 0; --n3) {
            this.update(byArray[n4]);
            ++n4;
        }
        while (n3 > this.xBuf.length) {
            this.processWord(byArray, n4);
            n4 += this.xBuf.length;
            n3 -= this.xBuf.length;
            this.byteCount1 += (long)this.xBuf.length;
        }
        while (n3 > 0) {
            this.update(byArray[n4]);
            ++n4;
            --n3;
        }
    }

    void finish() {
        this.adjustByteCounts();
        long l = this.byteCount1 << 3;
        long l2 = this.byteCount2;
        this.update((byte)-128);
        while (this.xBufOff != 0) {
            this.update((byte)0);
        }
        this.processLength(l, l2);
        this.processBlock();
    }

    @Override
    public void reset() {
        int n;
        this.byteCount1 = 0L;
        this.byteCount2 = 0L;
        this.xBufOff = 0;
        for (n = 0; n < this.xBuf.length; ++n) {
            this.xBuf[n] = 0;
        }
        this.wOff = 0;
        for (n = 0; n != this.wValue.length; ++n) {
            this.wValue[n] = 0L;
        }
    }

    @Override
    public int getByteLength() {
        return 128;
    }

    protected void processWord(byte[] byArray, int n) {
        this.wValue[this.wOff] = Pack.bigEndianToLong(byArray, n);
        if (++this.wOff == 16) {
            this.processBlock();
        }
    }

    private void adjustByteCounts() {
        if (this.byteCount1 > 0x1FFFFFFFFFFFFFFFL) {
            this.byteCount2 += this.byteCount1 >>> 61;
            this.byteCount1 &= 0x1FFFFFFFFFFFFFFFL;
        }
    }

    protected void processLength(long l, long l2) {
        if (this.wOff > 14) {
            this.processBlock();
        }
        this.wValue[14] = l2;
        this.wValue[15] = l;
    }

    protected void processBlock() {
        int n;
        this.adjustByteCounts();
        for (int i = 16; i <= 79; ++i) {
            this.wValue[i] = LongDigest.sigma1(this.wValue[i - 2]) + this.wValue[i - 7] + LongDigest.sigma0(this.wValue[i - 15]) + this.wValue[i - 16];
        }
        long l = this.h1Value;
        long l2 = this.h2Value;
        long l3 = this.h3Value;
        long l4 = this.h4Value;
        long l5 = this.h5Value;
        long l6 = this.h6Value;
        long l7 = this.h7Value;
        long l8 = this.h8Value;
        int n2 = 0;
        for (n = 0; n < 10; ++n) {
            long l9 = LongDigest.sum1(l5) + LongDigest.ch(l5, l6, l7) + K_VALUE[n2];
            int n3 = n2++;
            l8 += LongDigest.sum0(l) + LongDigest.maj(l, l2, l3);
            long l10 = LongDigest.sum1(l4 += (l8 += l9 + this.wValue[n3])) + LongDigest.ch(l4, l5, l6) + K_VALUE[n2];
            int n4 = n2++;
            l7 += LongDigest.sum0(l8) + LongDigest.maj(l8, l, l2);
            long l11 = LongDigest.sum1(l3 += (l7 += l10 + this.wValue[n4])) + LongDigest.ch(l3, l4, l5) + K_VALUE[n2];
            int n5 = n2++;
            l6 += LongDigest.sum0(l7) + LongDigest.maj(l7, l8, l);
            long l12 = LongDigest.sum1(l2 += (l6 += l11 + this.wValue[n5])) + LongDigest.ch(l2, l3, l4) + K_VALUE[n2];
            int n6 = n2++;
            l5 += LongDigest.sum0(l6) + LongDigest.maj(l6, l7, l8);
            long l13 = LongDigest.sum1(l += (l5 += l12 + this.wValue[n6])) + LongDigest.ch(l, l2, l3) + K_VALUE[n2];
            int n7 = n2++;
            l4 += LongDigest.sum0(l5) + LongDigest.maj(l5, l6, l7);
            long l14 = LongDigest.sum1(l8 += (l4 += l13 + this.wValue[n7])) + LongDigest.ch(l8, l, l2) + K_VALUE[n2];
            int n8 = n2++;
            l3 += LongDigest.sum0(l4) + LongDigest.maj(l4, l5, l6);
            long l15 = LongDigest.sum1(l7 += (l3 += l14 + this.wValue[n8])) + LongDigest.ch(l7, l8, l) + K_VALUE[n2];
            int n9 = n2++;
            l2 += LongDigest.sum0(l3) + LongDigest.maj(l3, l4, l5);
            l5 += (l += LongDigest.sum1(l6 += (l2 += l15 + this.wValue[n9])) + LongDigest.ch(l6, l7, l8) + K_VALUE[n2] + this.wValue[n2++]);
            l += LongDigest.sum0(l2) + LongDigest.maj(l2, l3, l4);
        }
        this.h1Value += l;
        this.h2Value += l2;
        this.h3Value += l3;
        this.h4Value += l4;
        this.h5Value += l5;
        this.h6Value += l6;
        this.h7Value += l7;
        this.h8Value += l8;
        this.wOff = 0;
        for (n = 0; n < 16; ++n) {
            this.wValue[n] = 0L;
        }
    }

    private static long ch(long l, long l2, long l3) {
        return l & l2 ^ (l ^ 0xFFFFFFFFFFFFFFFFL) & l3;
    }

    private static long maj(long l, long l2, long l3) {
        return l & l2 ^ l & l3 ^ l2 & l3;
    }

    private static long sum0(long l) {
        return (l << 36 | l >>> 28) ^ (l << 30 | l >>> 34) ^ (l << 25 | l >>> 39);
    }

    private static long sum1(long l) {
        return (l << 50 | l >>> 14) ^ (l << 46 | l >>> 18) ^ (l << 23 | l >>> 41);
    }

    private static long sigma0(long l) {
        return (l << 63 | l >>> 1) ^ (l << 56 | l >>> 8) ^ l >>> 7;
    }

    private static long sigma1(long l) {
        return (l << 45 | l >>> 19) ^ (l << 3 | l >>> 61) ^ l >>> 6;
    }
}

