/*
 * Decompiled with CFR 0.152.
 */
package es.gob.jmulticard.jse.provider.digest;

import es.gob.jmulticard.jse.provider.digest.ExtendedDigest;

abstract class GeneralDigest
implements ExtendedDigest {
    private static final int BYTE_LENGTH = 64;
    private final byte[] xBuf = new byte[4];
    private int xBufOff = 0;
    private long byteCount;

    protected GeneralDigest() {
    }

    @Override
    public void update(byte by) {
        this.xBuf[this.xBufOff++] = by;
        if (this.xBufOff == this.xBuf.length) {
            this.processWord(this.xBuf, 0);
            this.xBufOff = 0;
        }
        ++this.byteCount;
    }

    @Override
    public void update(byte[] byArray, int n, int n2) {
        int n3;
        int n4 = n;
        for (n3 = n2; this.xBufOff != 0 && n3 > 0; --n3) {
            this.update(byArray[n4]);
            ++n4;
        }
        while (n3 > this.xBuf.length) {
            this.processWord(byArray, n4);
            n4 += this.xBuf.length;
            n3 -= this.xBuf.length;
            this.byteCount += (long)this.xBuf.length;
        }
        while (n3 > 0) {
            this.update(byArray[n4]);
            ++n4;
            --n3;
        }
    }

    void finish() {
        long l = this.byteCount << 3;
        this.update((byte)-128);
        while (this.xBufOff != 0) {
            this.update((byte)0);
        }
        this.processLength(l);
        this.processBlock();
    }

    @Override
    public void reset() {
        this.byteCount = 0L;
        this.xBufOff = 0;
        for (int i = 0; i < this.xBuf.length; ++i) {
            this.xBuf[i] = 0;
        }
    }

    @Override
    public int getByteLength() {
        return 64;
    }

    protected abstract void processWord(byte[] var1, int var2);

    protected abstract void processLength(long var1);

    protected abstract void processBlock();
}

