/*
 * Decompiled with CFR 0.152.
 */
package es.gob.jmulticard.jse.provider;

import es.gob.jmulticard.CryptoHelper;
import es.gob.jmulticard.jse.provider.digest.Digest;
import es.gob.jmulticard.jse.provider.digest.SHA1Digest;
import es.gob.jmulticard.jse.provider.digest.SHA256Digest;
import es.gob.jmulticard.jse.provider.digest.SHA384Digest;
import es.gob.jmulticard.jse.provider.digest.SHA512Digest;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public final class JseCryptoHelper
implements CryptoHelper {
    private static final String SHA512 = "SHA-512";
    private static final String SHA384 = "SHA-384";
    private static final String SHA256 = "SHA-256";
    private static final String SHA1 = "SHA-1";

    @Override
    public byte[] digest(String string, byte[] byArray) throws IOException {
        if (string == null) {
            throw new IllegalArgumentException("El algoritmo de huella digital no puede ser nulo");
        }
        String string2 = JseCryptoHelper.normalizeDigestAlgorithm(string);
        try {
            Digest digest = JseCryptoHelper.selectMessageDigest(string2);
            digest.update(byArray, 0, byArray.length);
            byte[] byArray2 = new byte[digest.getDigestSize()];
            digest.doFinal(byArray2, 0);
            return byArray2;
        }
        catch (Exception exception) {
            throw new IOException("Error obteniendo la huella digital de los datos: " + exception, exception);
        }
    }

    private static Digest selectMessageDigest(String string) {
        if (SHA1.equals(string)) {
            return new SHA1Digest();
        }
        if (SHA256.equals(string)) {
            return new SHA256Digest();
        }
        if (SHA384.equals(string)) {
            return new SHA384Digest();
        }
        if (SHA512.equals(string)) {
            return new SHA512Digest();
        }
        return null;
    }

    private static String normalizeDigestAlgorithm(String string) {
        if ("SHA".equalsIgnoreCase(string) || "SHA1".equalsIgnoreCase(string) || SHA1.equalsIgnoreCase(string)) {
            return SHA1;
        }
        if ("SHA256".equalsIgnoreCase(string) || SHA256.equalsIgnoreCase(string)) {
            return SHA256;
        }
        if ("SHA384".equalsIgnoreCase(string) || SHA384.equalsIgnoreCase(string)) {
            return SHA384;
        }
        if ("SHA512".equalsIgnoreCase(string) || SHA512.equalsIgnoreCase(string)) {
            return SHA512;
        }
        return null;
    }

    private static byte[] doDesede(byte[] byArray, byte[] byArray2, int n) throws IOException {
        byte[] byArray3 = new byte[8];
        for (int i = 0; i < 8; ++i) {
            byArray3[i] = 0;
        }
        SecretKeySpec secretKeySpec = new SecretKeySpec(JseCryptoHelper.prepareDesedeKey(byArray2), "DESede");
        try {
            Cipher cipher = Cipher.getInstance("DESede/CBC/NoPadding");
            cipher.init(n, (Key)secretKeySpec, new IvParameterSpec(byArray3));
            byte[] byArray4 = cipher.doFinal(byArray);
            for (int i = 0; i < byArray.length; ++i) {
                byArray[i] = 0;
            }
            return byArray4;
        }
        catch (Exception exception) {
            for (int i = 0; i < byArray.length; ++i) {
                byArray[i] = 0;
            }
            throw new IOException("Error encriptando datos: " + exception, exception);
        }
    }

    @Override
    public byte[] desedeEncrypt(byte[] byArray, byte[] byArray2) throws IOException {
        return JseCryptoHelper.doDesede(byArray, byArray2, 1);
    }

    @Override
    public byte[] desedeDecrypt(byte[] byArray, byte[] byArray2) throws IOException {
        return JseCryptoHelper.doDesede(byArray, byArray2, 2);
    }

    private static byte[] prepareDesedeKey(byte[] byArray) {
        if (byArray == null) {
            throw new IllegalArgumentException("La clave 3DES no puede ser nula");
        }
        if (byArray.length == 24) {
            return byArray;
        }
        if (byArray.length == 16) {
            byte[] byArray2 = new byte[24];
            System.arraycopy(byArray, 0, byArray2, 0, 16);
            System.arraycopy(byArray, 0, byArray2, 16, 8);
            return byArray2;
        }
        throw new IllegalArgumentException("Longitud de clave invalida, se esperaba 16 o 24, pero se indico " + Integer.toString(byArray.length));
    }

    private static byte[] doDes(byte[] byArray, byte[] byArray2, int n) throws IOException {
        if (byArray2 == null) {
            throw new IllegalArgumentException("La clave DES no puede ser nula");
        }
        if (byArray2.length != 8) {
            throw new IllegalArgumentException("La clave DES debe ser de 8 octetos, pero la proporcionada es de " + byArray2.length);
        }
        try {
            Cipher cipher = Cipher.getInstance("DES/ECB/NoPadding");
            cipher.init(n, new SecretKeySpec(byArray2, "DES"));
            return cipher.doFinal(byArray);
        }
        catch (Exception exception) {
            throw new IOException("Error cifrando los datos con DES: " + exception, exception);
        }
    }

    @Override
    public byte[] desEncrypt(byte[] byArray, byte[] byArray2) throws IOException {
        return JseCryptoHelper.doDes(byArray, byArray2, 1);
    }

    @Override
    public byte[] desDecrypt(byte[] byArray, byte[] byArray2) throws IOException {
        return JseCryptoHelper.doDes(byArray, byArray2, 2);
    }

    private static byte[] doRsa(byte[] byArray, Key key, int n) throws IOException {
        try {
            Cipher cipher = Cipher.getInstance("RSA/ECB/NOPADDING");
            cipher.init(n, key);
            return cipher.doFinal(byArray);
        }
        catch (Exception exception) {
            throw new IOException("Error descifrando los datos mediante la clave RSA: " + exception, exception);
        }
    }

    @Override
    public byte[] rsaDecrypt(byte[] byArray, Key key) throws IOException {
        return JseCryptoHelper.doRsa(byArray, key, 2);
    }

    @Override
    public byte[] rsaEncrypt(byte[] byArray, Key key) throws IOException {
        return JseCryptoHelper.doRsa(byArray, key, 1);
    }

    @Override
    public Certificate generateCertificate(byte[] byArray) throws CertificateException {
        return CertificateFactory.getInstance("X.509").generateCertificate(new ByteArrayInputStream(byArray));
    }

    @Override
    public byte[] generateRandomBytes(int n) throws IOException {
        SecureRandom secureRandom;
        try {
            secureRandom = SecureRandom.getInstance("SHA1PRNG");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new IOException("Algoritmo de generacion de aleatorios no valido: " + noSuchAlgorithmException, noSuchAlgorithmException);
        }
        byte[] byArray = new byte[n];
        secureRandom.nextBytes(byArray);
        return byArray;
    }
}

