/*
 * Decompiled with CFR 0.152.
 */
package es.gob.jmulticard.jse.provider;

import es.gob.jmulticard.card.BadPinException;
import es.gob.jmulticard.card.CryptoCardException;
import es.gob.jmulticard.card.dnie.Dnie;
import es.gob.jmulticard.card.dnie.DniePrivateKeyReference;
import es.gob.jmulticard.jse.provider.DniePrivateKey;
import es.gob.jmulticard.jse.provider.DnieProvider;
import es.gob.jmulticard.jse.provider.SignatureAuthException;
import java.io.ByteArrayOutputStream;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.ProviderException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.SignatureSpi;

abstract class DnieSignatureImpl
extends SignatureSpi {
    private final ByteArrayOutputStream data = new ByteArrayOutputStream();
    private Signature signatureVerifier = null;
    private DniePrivateKey privateKey = null;
    private final String signatureAlgo;

    DnieSignatureImpl(String string) {
        this.signatureAlgo = string;
    }

    @Override
    protected Object engineGetParameter(String string) {
        throw new InvalidParameterException("Parametro no soportado");
    }

    @Override
    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        if (privateKey == null) {
            throw new InvalidKeyException("La clave proporcionada es nula");
        }
        if (!(privateKey instanceof DniePrivateKey)) {
            throw new InvalidKeyException("La clave proporcionada no es de un DNIe: " + privateKey.getClass().getName());
        }
        this.privateKey = (DniePrivateKey)privateKey;
        this.data.reset();
    }

    @Override
    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        this.data.reset();
        try {
            this.signatureVerifier = Signature.getInstance(this.signatureAlgo);
            try {
                if (this.signatureVerifier.getProvider() instanceof DnieProvider) {
                    this.signatureVerifier = Signature.getInstance(this.signatureAlgo, "SunRsaSign");
                }
            }
            catch (NoSuchProviderException noSuchProviderException) {
                throw new IllegalStateException("No esta instalado el proveedor SunRsaSign", noSuchProviderException);
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new IllegalStateException("No existe un proveedor para validar firmas con el algoritmo " + this.signatureAlgo, noSuchAlgorithmException);
        }
        this.signatureVerifier.initVerify(publicKey);
    }

    @Override
    protected void engineSetParameter(String string, Object object) {
        throw new InvalidParameterException("Parametro no soportado");
    }

    @Override
    protected byte[] engineSign() throws SignatureException {
        if (!(this.privateKey.getCryptoCard() instanceof Dnie)) {
            throw new ProviderException("La clave proporcionada no se corresponde con la de un DNIe");
        }
        DniePrivateKeyReference dniePrivateKeyReference = new DniePrivateKeyReference((Dnie)this.privateKey.getCryptoCard(), this.privateKey.getId(), this.privateKey.getPath(), this.privateKey.toString());
        try {
            return this.privateKey.getCryptoCard().sign(this.data.toByteArray(), this.signatureAlgo, dniePrivateKeyReference);
        }
        catch (CryptoCardException cryptoCardException) {
            throw new SignatureException(cryptoCardException);
        }
        catch (BadPinException badPinException) {
            throw new SignatureAuthException(badPinException);
        }
    }

    @Override
    protected void engineUpdate(byte by) throws SignatureException {
        this.data.write(by);
    }

    @Override
    protected void engineUpdate(byte[] byArray, int n, int n2) throws SignatureException {
        this.data.write(byArray, n, n2);
    }

    @Override
    protected boolean engineVerify(byte[] byArray) throws SignatureException {
        if (this.signatureVerifier == null) {
            throw new SignatureException("La verificacion no esta inicializada");
        }
        this.signatureVerifier.update(this.data.toByteArray());
        this.data.reset();
        return this.signatureVerifier.verify(byArray);
    }

    public static final class Sha512
    extends DnieSignatureImpl {
        public Sha512() {
            super("SHA512withRSA");
        }
    }

    public static final class Sha384
    extends DnieSignatureImpl {
        public Sha384() {
            super("SHA384withRSA");
        }
    }

    public static final class Sha256
    extends DnieSignatureImpl {
        public Sha256() {
            super("SHA256withRSA");
        }
    }

    public static final class Sha1
    extends DnieSignatureImpl {
        public Sha1() {
            super("SHA1withRSA");
        }
    }
}

