/*
 * Decompiled with CFR 0.152.
 */
package es.gob.jmulticard.jse.provider;

import es.gob.jmulticard.apdu.connection.ApduConnection;
import java.io.FileDescriptor;
import java.net.InetAddress;
import java.net.SocketPermission;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.security.Provider;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;

public final class DnieProvider
extends Provider {
    private static final String SHA512WITH_RSA = "SHA512withRSA";
    private static final String SHA384WITH_RSA = "SHA384withRSA";
    private static final String SHA256WITH_RSA = "SHA256withRSA";
    private static final String SHA1WITH_RSA = "SHA1withRSA";
    private static final String ES_GOB_JMULTICARD_CARD_DNIE_DNIE_PRIVATE_KEY = "es.gob.jmulticard.jse.provider.DniePrivateKey";
    private static final long serialVersionUID = -1046745919235177156L;
    private static final String INFO = "Proveedor para el DNIe";
    private static final double VERSION = 0.2;
    private static final String NAME = "DNIeJCAProvider";
    private static ApduConnection defaultConnection = null;

    static ApduConnection getDefaultApduConnection() {
        return defaultConnection;
    }

    public DnieProvider() {
        this((ApduConnection)null);
    }

    public DnieProvider(ApduConnection apduConnection) {
        super(NAME, 0.2, INFO);
        defaultConnection = apduConnection;
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                if (!"Dalvik".equals(System.getProperty("java.vm.name"))) {
                    if (!(System.getSecurityManager() instanceof DnieSecurityManager)) {
                        System.setSecurityManager(new DnieSecurityManager(System.getSecurityManager()));
                    }
                } else {
                    Logger.getLogger("es.gob.jmulticard").info("En Android se omite la instalacion del gestor de seguridad");
                }
                return null;
            }
        });
        this.put("KeyStore.DNI", "es.gob.jmulticard.jse.provider.DnieKeyStoreImpl");
        this.put("Signature.SHA1withRSA", "es.gob.jmulticard.jse.provider.DnieSignatureImpl$Sha1");
        this.put("Signature.SHA256withRSA", "es.gob.jmulticard.jse.provider.DnieSignatureImpl$Sha256");
        this.put("Signature.SHA384withRSA", "es.gob.jmulticard.jse.provider.DnieSignatureImpl$Sha384");
        this.put("Signature.SHA512withRSA", "es.gob.jmulticard.jse.provider.DnieSignatureImpl$Sha512");
        this.put("Signature.SHA1withRSA SupportedKeyClasses", ES_GOB_JMULTICARD_CARD_DNIE_DNIE_PRIVATE_KEY);
        this.put("Signature.SHA256withRSA SupportedKeyClasses", ES_GOB_JMULTICARD_CARD_DNIE_DNIE_PRIVATE_KEY);
        this.put("Signature.SHA384withRSA SupportedKeyClasses", ES_GOB_JMULTICARD_CARD_DNIE_DNIE_PRIVATE_KEY);
        this.put("Signature.SHA512withRSA SupportedKeyClasses", ES_GOB_JMULTICARD_CARD_DNIE_DNIE_PRIVATE_KEY);
        this.put("Alg.Alias.Signature.1.2.840.113549.1.1.5", SHA1WITH_RSA);
        this.put("Alg.Alias.Signature.OID.1.2.840.113549.1.1.5", SHA1WITH_RSA);
        this.put("Alg.Alias.Signature.1.3.14.3.2.29", SHA1WITH_RSA);
        this.put("Alg.Alias.Signature.SHAwithRSA", SHA1WITH_RSA);
        this.put("Alg.Alias.Signature.SHA-1withRSA", SHA1WITH_RSA);
        this.put("Alg.Alias.Signature.SHA1withRSAEncryption", SHA1WITH_RSA);
        this.put("Alg.Alias.Signature.SHA-1withRSAEncryption", SHA1WITH_RSA);
        this.put("Alg.Alias.Signature.1.2.840.113549.1.1.11", SHA256WITH_RSA);
        this.put("Alg.Alias.Signature.OID.1.2.840.113549.1.1.11", SHA256WITH_RSA);
        this.put("Alg.Alias.Signature.SHA-256withRSA", SHA256WITH_RSA);
        this.put("Alg.Alias.Signature.SHA-256withRSAEncryption", SHA256WITH_RSA);
        this.put("Alg.Alias.Signature.SHA256withRSAEncryption", SHA256WITH_RSA);
        this.put("Alg.Alias.Signature.1.2.840.113549.1.1.12", SHA384WITH_RSA);
        this.put("Alg.Alias.Signature.OID.1.2.840.113549.1.1.12", SHA384WITH_RSA);
        this.put("Alg.Alias.Signature.SHA-384withRSA", SHA384WITH_RSA);
        this.put("Alg.Alias.Signature.SHA-384withRSAEncryption", SHA384WITH_RSA);
        this.put("Alg.Alias.Signature.SHA384withRSAEncryption", SHA384WITH_RSA);
        this.put("Alg.Alias.Signature.1.2.840.113549.1.1.13", SHA512WITH_RSA);
        this.put("Alg.Alias.Signature.OID.1.2.840.113549.1.1.13", SHA512WITH_RSA);
        this.put("Alg.Alias.Signature.SHA-512withRSA", SHA512WITH_RSA);
        this.put("Alg.Alias.Signature.SHA-512withRSAEncryption", SHA512WITH_RSA);
        this.put("Alg.Alias.Signature.SHA512withRSAEncryption", SHA512WITH_RSA);
    }

    private static final class DnieSecurityManager
    extends SecurityManager {
        private final SecurityManager sm;
        private static final List<String> ALLOWED_MEMBER_ACCESS_PREFIXES = new ArrayList<String>(4);
        private static final Set<String> DENIED_PREMISSIONS_NAMES;

        DnieSecurityManager(SecurityManager securityManager) {
            this.sm = securityManager;
        }

        @Override
        public void checkAccept(String string, int n) {
            if (this.sm != null) {
                this.sm.checkAccept(string, n);
            }
        }

        @Override
        public void checkAccess(Thread thread) {
            if (this.sm != null) {
                this.sm.checkAccess(thread);
            }
        }

        @Override
        public void checkAccess(ThreadGroup threadGroup) {
            if (this.sm != null) {
                this.sm.checkAccess(threadGroup);
            }
        }

        public void checkAwtEventQueueAccess() {
            if (this.sm != null) {
                this.sm.checkAwtEventQueueAccess();
            }
        }

        @Override
        public void checkConnect(String string, int n) {
            if (this.sm != null) {
                this.sm.checkConnect(string, n);
            }
        }

        @Override
        public void checkConnect(String string, int n, Object object) {
            if (this.sm != null) {
                this.sm.checkConnect(string, n, object);
            }
        }

        @Override
        public void checkCreateClassLoader() {
            if (this.sm != null) {
                this.sm.checkCreateClassLoader();
            }
        }

        @Override
        public void checkDelete(String string) {
            if (this.sm != null) {
                this.sm.checkDelete(string);
            }
        }

        @Override
        public void checkExec(String string) {
            if (this.sm != null) {
                this.sm.checkExec(string);
            }
        }

        @Override
        public void checkExit(int n) {
            if (this.sm != null) {
                this.sm.checkExit(n);
            }
        }

        @Override
        public void checkLink(String string) {
            if (this.sm != null) {
                this.sm.checkLink(string);
            }
        }

        @Override
        public void checkListen(int n) {
            if (this.sm != null) {
                this.sm.checkListen(n);
            }
        }

        public void checkMemberAccess(Class<?> clazz, int n) {
            super.checkMemberAccess(clazz, n);
            if (clazz.getName().startsWith("es.gob.jmulticard")) {
                for (String string : ALLOWED_MEMBER_ACCESS_PREFIXES) {
                    if (!clazz.getName().startsWith(string)) continue;
                    if (this.sm != null) {
                        this.sm.checkMemberAccess(clazz, n);
                    }
                    return;
                }
                throw new SecurityException("No se permite el acceso por reflexion a esta clase: " + clazz);
            }
            if (this.sm != null) {
                this.sm.checkMemberAccess(clazz, n);
            }
        }

        @Override
        public void checkMulticast(InetAddress inetAddress) {
            if (this.sm != null) {
                this.sm.checkMulticast(inetAddress);
            }
        }

        @Override
        public void checkMulticast(InetAddress inetAddress, byte by) {
            if (this.sm != null) {
                this.sm.checkPermission(new SocketPermission(inetAddress.getHostAddress(), "accept,connect"));
            }
        }

        @Override
        public void checkPackageAccess(String string) {
            super.checkPackageAccess(string);
            if (this.sm != null) {
                this.sm.checkPackageAccess(string);
            }
        }

        @Override
        public void checkPackageDefinition(String string) {
            super.checkPackageDefinition(string);
            if (string != null && string.startsWith("es.gob.jmulticard")) {
                throw new SecurityException("No se permite la creacion de clases en este paquete");
            }
            if (this.sm != null) {
                this.sm.checkPackageDefinition(string);
            }
        }

        @Override
        public void checkPermission(Permission permission) {
            if (DENIED_PREMISSIONS_NAMES.contains(permission.getName())) {
                throw new SecurityException("Operacion no permitida: " + permission);
            }
            if (this.sm != null) {
                this.sm.checkPermission(permission);
            }
        }

        @Override
        public void checkPermission(Permission permission, Object object) {
            if (this.sm != null) {
                this.sm.checkPermission(permission, object);
            }
        }

        @Override
        public void checkPrintJobAccess() {
            if (this.sm != null) {
                this.sm.checkPrintJobAccess();
            }
        }

        @Override
        public void checkPropertiesAccess() {
            if (this.sm != null) {
                this.sm.checkPropertiesAccess();
            }
        }

        @Override
        public void checkPropertyAccess(String string) {
            if (this.sm != null) {
                this.sm.checkPropertyAccess(string);
            }
        }

        @Override
        public void checkRead(FileDescriptor fileDescriptor) {
            if (this.sm != null) {
                this.sm.checkRead(fileDescriptor);
            }
        }

        @Override
        public void checkRead(String string) {
            if (this.sm != null) {
                this.sm.checkRead(string);
            }
        }

        @Override
        public void checkRead(String string, Object object) {
            if (this.sm != null) {
                this.sm.checkRead(string, object);
            }
        }

        @Override
        public void checkSecurityAccess(String string) {
            if (this.sm != null) {
                this.sm.checkSecurityAccess(string);
            }
        }

        @Override
        public void checkSetFactory() {
            if (this.sm != null) {
                this.sm.checkSetFactory();
            }
        }

        public void checkSystemClipboardAccess() {
            if (this.sm != null) {
                this.sm.checkSystemClipboardAccess();
            }
        }

        public boolean checkTopLevelWindow(Object object) {
            if (this.sm != null) {
                return this.sm.checkTopLevelWindow(object);
            }
            return true;
        }

        @Override
        public void checkWrite(FileDescriptor fileDescriptor) {
            if (this.sm != null) {
                this.sm.checkWrite(fileDescriptor);
            }
        }

        @Override
        public void checkWrite(String string) {
            if (this.sm != null) {
                this.sm.checkWrite(string);
            }
        }

        static {
            ALLOWED_MEMBER_ACCESS_PREFIXES.add("es.gob.jmulticard.asn1.der");
            ALLOWED_MEMBER_ACCESS_PREFIXES.add("es.gob.jmulticard.ui.passwordcallback");
            ALLOWED_MEMBER_ACCESS_PREFIXES.add("es.gob.jmulticard.jse.provider.DnieProvider");
            ALLOWED_MEMBER_ACCESS_PREFIXES.add("es.gob.jmulticard.jse.provider.DnieKeyStoreImpl");
            ALLOWED_MEMBER_ACCESS_PREFIXES.add("es.gob.jmulticard.jse.provider.DnieSignatureImpl");
            ALLOWED_MEMBER_ACCESS_PREFIXES.add("es.gob.jmulticard.jse.smartcardio");
            DENIED_PREMISSIONS_NAMES = new HashSet<String>(8);
            DENIED_PREMISSIONS_NAMES.add("setPolicy");
            DENIED_PREMISSIONS_NAMES.add("clearProviderProperties.DNIeJCAProvider");
            DENIED_PREMISSIONS_NAMES.add("putProviderProperty.DNIeJCAProvider");
            DENIED_PREMISSIONS_NAMES.add("removeProviderProperty.DNIeJCAProvider");
            DENIED_PREMISSIONS_NAMES.add("readDisplayPixels");
            DENIED_PREMISSIONS_NAMES.add("setSecurityManager");
        }
    }
}

