/*
 * Decompiled with CFR 0.152.
 */
package es.gob.jmulticard.jse.provider;

import es.gob.jmulticard.apdu.connection.ApduConnection;
import es.gob.jmulticard.card.AuthenticationModeLockedException;
import es.gob.jmulticard.card.BadPinException;
import es.gob.jmulticard.card.CryptoCard;
import es.gob.jmulticard.card.CryptoCardException;
import es.gob.jmulticard.card.PrivateKeyReference;
import es.gob.jmulticard.card.dnie.Dnie;
import es.gob.jmulticard.card.dnie.DniePrivateKeyReference;
import es.gob.jmulticard.jse.provider.BadPasswordProviderException;
import es.gob.jmulticard.jse.provider.DniePrivateKey;
import es.gob.jmulticard.jse.provider.DnieProvider;
import es.gob.jmulticard.jse.provider.JseCryptoHelper;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.KeyStoreSpi;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.ProviderException;
import java.security.UnrecoverableEntryException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.logging.Logger;
import javax.security.auth.callback.PasswordCallback;

public final class DnieKeyStoreImpl
extends KeyStoreSpi {
    private static final String INTERMEDIATE_CA_CERT_ALIAS = "CertCAIntermediaDGP";
    private static final List<String> USERS_CERTS_ALIASES = new ArrayList<String>(2);
    private CryptoCard cryptoCard = null;

    @Override
    public Enumeration<String> engineAliases() {
        return Collections.enumeration(USERS_CERTS_ALIASES);
    }

    @Override
    public boolean engineContainsAlias(String string) {
        return USERS_CERTS_ALIASES.contains(string);
    }

    @Override
    public void engineDeleteEntry(String string) throws KeyStoreException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Certificate engineGetCertificate(String string) {
        if (!this.engineContainsAlias(string)) {
            return null;
        }
        try {
            return this.cryptoCard.getCertificate(string);
        }
        catch (CryptoCardException cryptoCardException) {
            throw new ProviderException(cryptoCardException);
        }
        catch (BadPinException badPinException) {
            throw new BadPasswordProviderException(badPinException);
        }
    }

    @Override
    public String engineGetCertificateAlias(Certificate certificate) {
        if (!(certificate instanceof X509Certificate)) {
            return null;
        }
        BigInteger bigInteger = ((X509Certificate)certificate).getSerialNumber();
        for (String string : USERS_CERTS_ALIASES) {
            if (((X509Certificate)this.engineGetCertificate(string)).getSerialNumber() != bigInteger) continue;
            return string;
        }
        return null;
    }

    @Override
    public Certificate[] engineGetCertificateChain(String string) {
        X509Certificate x509Certificate;
        if (!this.engineContainsAlias(string)) {
            return null;
        }
        try {
            x509Certificate = this.cryptoCard.getCertificate(INTERMEDIATE_CA_CERT_ALIAS);
        }
        catch (AuthenticationModeLockedException authenticationModeLockedException) {
            throw authenticationModeLockedException;
        }
        catch (Exception exception) {
            Logger.getLogger("es.gob.jmulticard").warning("No se ha podido cargar el certificado de la CA intermedia");
            x509Certificate = null;
        }
        if (x509Certificate == null) {
            return new X509Certificate[]{(X509Certificate)this.engineGetCertificate(string)};
        }
        return new X509Certificate[]{(X509Certificate)this.engineGetCertificate(string), x509Certificate};
    }

    @Override
    public Date engineGetCreationDate(String string) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Key engineGetKey(String string, char[] cArray) throws NoSuchAlgorithmException, UnrecoverableKeyException {
        if (cArray != null) {
            Logger.getLogger("es.gob.jmulticard").warning("Se ha proporcionado una contrasena, pero esta se ignorara, ya que el PIN se gestiona internamente");
        }
        if (!this.engineContainsAlias(string)) {
            return null;
        }
        try {
            PrivateKeyReference privateKeyReference = this.cryptoCard.getPrivateKey(string);
            if (!(privateKeyReference instanceof DniePrivateKeyReference)) {
                throw new ProviderException("La clave obtenida de la tarjeta no es del tipo esperado, se ha obtenido: " + privateKeyReference.getClass().getName());
            }
            return new DniePrivateKey((DniePrivateKeyReference)privateKeyReference);
        }
        catch (CryptoCardException cryptoCardException) {
            throw new ProviderException(cryptoCardException);
        }
    }

    @Override
    public KeyStore.Entry engineGetEntry(String string, KeyStore.ProtectionParameter protectionParameter) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableEntryException {
        if (protectionParameter != null) {
            Logger.getLogger("es.gob.jmulticard").warning("Se ha proporcionado un ProtectionParameter, pero este se ignorara, ya que el PIN se gestiona internamente");
        }
        if (!this.engineContainsAlias(string)) {
            return null;
        }
        PrivateKey privateKey = (PrivateKey)this.engineGetKey(string, null);
        return new KeyStore.PrivateKeyEntry(privateKey, this.engineGetCertificateChain(string));
    }

    @Override
    public boolean engineIsCertificateEntry(String string) {
        return USERS_CERTS_ALIASES.contains(string);
    }

    @Override
    public boolean engineIsKeyEntry(String string) {
        return USERS_CERTS_ALIASES.contains(string);
    }

    @Override
    public void engineLoad(KeyStore.LoadStoreParameter loadStoreParameter) throws IOException, NoSuchAlgorithmException, CertificateException {
        ApduConnection apduConnection;
        if (loadStoreParameter != null) {
            throw new IllegalArgumentException("El LoadStoreParameter siempre debe ser null, la contrasena se gestiona internamente");
        }
        try {
            apduConnection = DnieProvider.getDefaultApduConnection() == null ? (ApduConnection)Class.forName("es.gob.jmulticard.jse.smartcardio.SmartcardIoConnection").newInstance() : DnieProvider.getDefaultApduConnection();
        }
        catch (Exception exception) {
            throw new IllegalStateException("No hay una conexion de APDU por defecto: " + exception);
        }
        this.cryptoCard = new Dnie(apduConnection, null, new JseCryptoHelper());
    }

    @Override
    public void engineLoad(InputStream inputStream, char[] cArray) throws IOException, NoSuchAlgorithmException, CertificateException {
        ApduConnection apduConnection;
        try {
            apduConnection = DnieProvider.getDefaultApduConnection() == null ? (ApduConnection)Class.forName("es.gob.jmulticard.jse.smartcardio.SmartcardIoConnection").newInstance() : DnieProvider.getDefaultApduConnection();
        }
        catch (Exception exception) {
            throw new IllegalStateException("No hay una conexion de APDU por defecto: " + exception);
        }
        this.cryptoCard = new Dnie(apduConnection, cArray != null ? new CachePasswordCallback(cArray) : null, new JseCryptoHelper());
    }

    @Override
    public void engineSetCertificateEntry(String string, Certificate certificate) throws KeyStoreException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void engineSetKeyEntry(String string, byte[] byArray, Certificate[] certificateArray) throws KeyStoreException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void engineSetKeyEntry(String string, Key key, char[] cArray, Certificate[] certificateArray) throws KeyStoreException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int engineSize() {
        return USERS_CERTS_ALIASES.size();
    }

    @Override
    public void engineStore(OutputStream outputStream, char[] cArray) throws IOException, NoSuchAlgorithmException, CertificateException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean engineEntryInstanceOf(String string, Class<? extends KeyStore.Entry> clazz) {
        if (!this.engineContainsAlias(string)) {
            return false;
        }
        return clazz.equals(KeyStore.PrivateKeyEntry.class);
    }

    static {
        USERS_CERTS_ALIASES.add("CertAutenticacion");
        USERS_CERTS_ALIASES.add("CertFirmaDigital");
    }

    private static final class CachePasswordCallback
    extends PasswordCallback {
        private static final long serialVersionUID = 816457144215238935L;

        public CachePasswordCallback(char[] cArray) {
            super(">", false);
            this.setPassword(cArray);
        }
    }
}

