/*
 * Decompiled with CFR 0.152.
 */
package es.gob.jmulticard.card.iso7816four;

import es.gob.jmulticard.apdu.StatusWord;
import java.util.Hashtable;

public class Iso7816FourCardException
extends Exception {
    private static final Hashtable<StatusWord, String> ERRORS = new Hashtable();
    private final StatusWord returnCode;
    private static final long serialVersionUID = 5935577997660561619L;

    Iso7816FourCardException(String string, StatusWord statusWord) {
        super(string);
        this.returnCode = statusWord;
    }

    Iso7816FourCardException(StatusWord statusWord) {
        super(ERRORS.get(statusWord));
        this.returnCode = statusWord;
    }

    public StatusWord getStatusWord() {
        return this.returnCode;
    }

    static {
        ERRORS.put(new StatusWord(98, -125), "El fichero seleccionado esta invalidado");
        ERRORS.put(new StatusWord(101, -127), "Fallo en la memoria");
        ERRORS.put(new StatusWord(103, 0), "Longitud incorrecta");
        ERRORS.put(new StatusWord(104, -126), "Securizacion de mensajes no soportada");
        ERRORS.put(new StatusWord(105, -126), "Condiciones de seguridad no satisfechas");
        ERRORS.put(new StatusWord(105, -125), "Metodo de autenticacion bloqueado");
        ERRORS.put(new StatusWord(105, -124), "Dato referenciado invalido");
        ERRORS.put(new StatusWord(105, -123), "Condiciones de uso no satisfechas");
        ERRORS.put(new StatusWord(105, -122), "Comando no permitido (no existe ningun EF seleccionado)");
        ERRORS.put(new StatusWord(106, -128), "Parametros incorrectos en el campo de datos");
        ERRORS.put(new StatusWord(106, -127), "Funcion no soportada.");
        ERRORS.put(new StatusWord(106, -126), "No se encuentra el fichero");
        ERRORS.put(new StatusWord(106, -125), "Registro no encontrado");
        ERRORS.put(new StatusWord(106, -124), "No hay suficiente espacio de memoria en el fichero");
        ERRORS.put(new StatusWord(106, -123), "La longitud de datos (Lc) es incompatible con la estructura TLV");
        ERRORS.put(new StatusWord(106, -122), "Parametros incorrectos en P1 o P2");
        ERRORS.put(new StatusWord(106, -121), "La longitud de los datos es inconsistente con P1-P2");
        ERRORS.put(new StatusWord(106, -120), "Datos referenciados no encontrados");
        ERRORS.put(new StatusWord(106, -119), "El fichero ya existe");
        ERRORS.put(new StatusWord(106, -118), "El nombre del DF ya existe");
        ERRORS.put(new StatusWord(107, 0), "Parametro(s) incorrecto(s) P1-P2");
        ERRORS.put(new StatusWord(110, 0), "Clase no soportada");
        ERRORS.put(new StatusWord(109, 0), "Comando no permitido en la fase de vida actual");
        ERRORS.put(new StatusWord(111, 0), "Diagnostico no preciso");
    }
}

