/*
 * Decompiled with CFR 0.152.
 */
package es.gob.jmulticard.card.iso7816four;

import es.gob.jmulticard.HexUtils;
import es.gob.jmulticard.apdu.ResponseApdu;
import es.gob.jmulticard.apdu.StatusWord;
import es.gob.jmulticard.apdu.connection.ApduConnection;
import es.gob.jmulticard.apdu.connection.ApduConnectionException;
import es.gob.jmulticard.apdu.connection.cwa14890.SecureChannelException;
import es.gob.jmulticard.apdu.iso7816four.GetChallengeApduCommand;
import es.gob.jmulticard.apdu.iso7816four.MseSetVerificationKeyApduCommand;
import es.gob.jmulticard.apdu.iso7816four.ReadBinaryApduCommand;
import es.gob.jmulticard.apdu.iso7816four.SelectDfByNameApduCommand;
import es.gob.jmulticard.apdu.iso7816four.SelectFileApduResponse;
import es.gob.jmulticard.apdu.iso7816four.SelectFileByIdApduCommand;
import es.gob.jmulticard.card.BadPinException;
import es.gob.jmulticard.card.Location;
import es.gob.jmulticard.card.SmartCard;
import es.gob.jmulticard.card.iso7816four.FileNotFoundException;
import es.gob.jmulticard.card.iso7816four.Iso7816FourCardException;
import es.gob.jmulticard.card.iso7816four.RequiredSecurityStateNotSatisfiedException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.security.auth.callback.PasswordCallback;

public abstract class Iso7816FourCard
extends SmartCard {
    private static final StatusWord UNSATISFIED_SECURITY_STATE = new StatusWord(105, -126);

    public Iso7816FourCard(byte by, ApduConnection apduConnection) throws ApduConnectionException {
        super(by, apduConnection);
    }

    private ResponseApdu readBinary(byte by, byte by2, byte by3) throws ApduConnectionException, RequiredSecurityStateNotSatisfiedException {
        ResponseApdu responseApdu = this.getConnection().transmit(new ReadBinaryApduCommand(this.getCla(), by, by2, by3));
        if (responseApdu.isOk()) {
            return responseApdu;
        }
        if (UNSATISFIED_SECURITY_STATE.equals(responseApdu.getStatusWord())) {
            throw new RequiredSecurityStateNotSatisfiedException(responseApdu.getStatusWord());
        }
        throw new ApduConnectionException("Respuesta invalida en la lectura de binario con el codigo: " + responseApdu.getStatusWord());
    }

    public byte[] readBinaryComplete(int n) throws IOException, RequiredSecurityStateNotSatisfiedException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        for (int i = 0; i < n; i += 239) {
            byte by = (byte)(i >> 8);
            byte by2 = (byte)(i & 0xFF);
            int n2 = n - i;
            ResponseApdu responseApdu = n2 < 239 ? this.readBinary(by, by2, (byte)n2) : this.readBinary(by, by2, (byte)-17);
            if (!responseApdu.isOk()) {
                return responseApdu.getStatusWord().getBytes();
            }
            byteArrayOutputStream.write(responseApdu.getData());
        }
        return byteArrayOutputStream.toByteArray();
    }

    public void selectFileByName(String string) throws ApduConnectionException, FileNotFoundException {
        this.selectFileByName(string.getBytes());
    }

    public void selectFileByName(byte[] byArray) throws ApduConnectionException, FileNotFoundException {
        ResponseApdu responseApdu = this.getConnection().transmit(new SelectDfByNameApduCommand(this.getCla(), byArray));
        if (responseApdu.isOk()) {
            return;
        }
        if (HexUtils.arrayEquals(responseApdu.getBytes(), new byte[]{106, -126})) {
            throw new FileNotFoundException(byArray);
        }
    }

    public int selectFileById(byte[] byArray) throws ApduConnectionException, Iso7816FourCardException {
        ResponseApdu responseApdu = this.getConnection().transmit(new SelectFileByIdApduCommand(this.getCla(), byArray));
        if (HexUtils.arrayEquals(responseApdu.getBytes(), new byte[]{106, -126})) {
            throw new FileNotFoundException(byArray);
        }
        SelectFileApduResponse selectFileApduResponse = new SelectFileApduResponse(responseApdu);
        if (selectFileApduResponse.isOk()) {
            return selectFileApduResponse.getFileLength();
        }
        StatusWord statusWord = selectFileApduResponse.getStatusWord();
        if (statusWord.equals(new StatusWord(106, -126))) {
            throw new FileNotFoundException(byArray);
        }
        throw new Iso7816FourCardException(statusWord);
    }

    public byte[] selectFileByIdAndRead(byte[] byArray) throws Iso7816FourCardException, IOException {
        int n = this.selectFileById(byArray);
        return this.readBinaryComplete(n);
    }

    public int selectFileByLocation(Location location) throws ApduConnectionException, Iso7816FourCardException {
        int n = 0;
        this.selectMasterFile();
        for (Location location2 = location; location2 != null; location2 = location2.getChild()) {
            byte[] byArray = location2.getFile();
            n = this.selectFileById(byArray);
        }
        return n;
    }

    public byte[] selectFileByLocationAndRead(Location location) throws IOException, Iso7816FourCardException {
        int n = this.selectFileByLocation(location);
        return this.readBinaryComplete(n);
    }

    protected abstract void selectMasterFile() throws ApduConnectionException, FileNotFoundException;

    public void setPublicKeyToVerification(byte[] byArray) throws SecureChannelException, ApduConnectionException {
        MseSetVerificationKeyApduCommand mseSetVerificationKeyApduCommand = new MseSetVerificationKeyApduCommand(0, byArray);
        ResponseApdu responseApdu = this.getConnection().transmit(mseSetVerificationKeyApduCommand);
        if (!responseApdu.isOk()) {
            throw new SecureChannelException("Error al seleccionar una clave publica para verificacion. Se obtuvo el error: " + HexUtils.hexify(responseApdu.getBytes(), true));
        }
    }

    public byte[] getChallenge() throws ApduConnectionException {
        ResponseApdu responseApdu = this.getConnection().transmit(new GetChallengeApduCommand(0));
        if (responseApdu.isOk()) {
            return responseApdu.getData();
        }
        throw new ApduConnectionException("Respuesta invalida en la obtencion de desafio con el codigo: " + responseApdu.getStatusWord());
    }

    public abstract void verifyPin(PasswordCallback var1) throws ApduConnectionException, BadPinException;
}

