/*
 * Decompiled with CFR 0.152.
 */
package es.gob.jmulticard.card.iso7816four;

import es.gob.jmulticard.HexUtils;
import es.gob.jmulticard.apdu.StatusWord;
import es.gob.jmulticard.card.iso7816four.Iso7816FourCardException;

public final class FileNotFoundException
extends Iso7816FourCardException {
    private static final long serialVersionUID = -1114043381519603316L;
    private final byte[] id;
    private static final StatusWord FILE_NOT_FOUND_RETURN_CODE = new StatusWord(106, -126);

    public FileNotFoundException() {
        super("Fichero no encontrado", FILE_NOT_FOUND_RETURN_CODE);
        this.id = null;
    }

    public FileNotFoundException(byte[] byArray) {
        super("Fichero no encontrado: " + HexUtils.hexify(byArray, false), FILE_NOT_FOUND_RETURN_CODE);
        this.id = new byte[byArray.length];
        System.arraycopy(byArray, 0, this.id, 0, byArray.length);
    }

    public FileNotFoundException(String string) {
        super("Fichero no encontrado: " + string, FILE_NOT_FOUND_RETURN_CODE);
        this.id = string.getBytes();
    }

    public byte[] getFileId() {
        byte[] byArray = new byte[this.id.length];
        System.arraycopy(this.id, 0, byArray, 0, this.id.length);
        return byArray;
    }
}

