/*
 * Decompiled with CFR 0.152.
 */
package es.gob.jmulticard.card.iso7816eight;

import es.gob.jmulticard.HexUtils;
import es.gob.jmulticard.apdu.ResponseApdu;
import es.gob.jmulticard.apdu.connection.ApduConnection;
import es.gob.jmulticard.apdu.connection.ApduConnectionException;
import es.gob.jmulticard.apdu.connection.cwa14890.SecureChannelException;
import es.gob.jmulticard.apdu.iso7816eight.PsoVerifyCertificateApduCommand;
import es.gob.jmulticard.card.iso7816four.Iso7816FourCard;

public abstract class Iso7816EightCard
extends Iso7816FourCard {
    public Iso7816EightCard(byte by, ApduConnection apduConnection) throws ApduConnectionException {
        super(by, apduConnection);
    }

    public void verifyCertificate(byte[] byArray) throws ApduConnectionException {
        PsoVerifyCertificateApduCommand psoVerifyCertificateApduCommand = new PsoVerifyCertificateApduCommand(0, byArray);
        ResponseApdu responseApdu = this.getConnection().transmit(psoVerifyCertificateApduCommand);
        if (!responseApdu.isOk()) {
            throw new SecureChannelException("Error en la verificacion del certificado. Se obtuvo el error: " + HexUtils.hexify(responseApdu.getBytes(), true));
        }
    }
}

