/*
 * Decompiled with CFR 0.152.
 */
package es.gob.jmulticard.card.gemalto.tuir5;

import es.gob.jmulticard.HexUtils;
import es.gob.jmulticard.apdu.CommandApdu;
import es.gob.jmulticard.apdu.ResponseApdu;
import es.gob.jmulticard.apdu.connection.ApduConnection;
import es.gob.jmulticard.apdu.connection.ApduConnectionException;
import es.gob.jmulticard.apdu.connection.CardNotPresentException;
import es.gob.jmulticard.apdu.connection.NoReadersFoundException;
import es.gob.jmulticard.apdu.gemalto.CheckVerifyRetriesLeftApduCommand;
import es.gob.jmulticard.apdu.gemalto.MseSetSignatureKeyApduCommand;
import es.gob.jmulticard.apdu.gemalto.VerifyApduCommand;
import es.gob.jmulticard.asn1.der.pkcs15.Cdf;
import es.gob.jmulticard.asn1.der.pkcs15.PrKdf;
import es.gob.jmulticard.card.Atr;
import es.gob.jmulticard.card.BadPinException;
import es.gob.jmulticard.card.CryptoCard;
import es.gob.jmulticard.card.CryptoCardException;
import es.gob.jmulticard.card.InvalidCardException;
import es.gob.jmulticard.card.Location;
import es.gob.jmulticard.card.PrivateKeyReference;
import es.gob.jmulticard.card.gemalto.tuir5.TuiPrivateKeyReference;
import es.gob.jmulticard.card.iso7816four.FileNotFoundException;
import es.gob.jmulticard.card.iso7816four.Iso7816FourCard;
import es.gob.jmulticard.card.iso7816four.Iso7816FourCardException;
import es.gob.jmulticard.card.iso7816four.RequiredSecurityStateNotSatisfiedException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.security.auth.callback.PasswordCallback;

public final class TuiR5
extends Iso7816FourCard
implements CryptoCard {
    private static final byte[] ATR_MASK = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
    private static final Atr ATR = new Atr(new byte[]{59, 111, 0, 0, -128, 102, -80, 7, 1, 1, 119, 7, 83, 2, 49, 16, -126, -112, 0}, ATR_MASK);
    private static final byte[][] APPLETS_AIDS = new byte[][]{{-96, 0, 0, 0, 24, 14, 0, 0, 1, 99, 66, 0}, {-96, 0, 0, 0, 24, 15, 0, 0, 1, 99, 66, 0}, {-96, 0, 0, 0, 24, 12, 0, 0, 1, 99, 66, 0}};
    private static final Location CDF_LOCATION = new Location("50005003");
    private static final Location PRKDF_LOCATION = new Location("50005001");
    private static byte CLA = 0;
    private static final Logger LOGGER = Logger.getLogger("es.gob.jmulticard");
    private final PasswordCallback passwordCallback;
    private static final Map<String, X509Certificate> certificatesByAlias = new LinkedHashMap<String, X509Certificate>();

    public TuiR5(ApduConnection apduConnection, PasswordCallback passwordCallback) throws Iso7816FourCardException, IOException {
        super((byte)0, apduConnection);
        if (passwordCallback == null) {
            throw new IllegalArgumentException("El PasswordCallback no puede ser nulo");
        }
        this.passwordCallback = passwordCallback;
        this.connect(apduConnection);
        this.selectPkcs15Applet();
        this.preloadCertificates();
        LOGGER.info("Intentos de PIN restantes: " + this.getRemainingPinRetries());
        this.verifyPin(this.passwordCallback);
        this.loadKeyReferences();
    }

    private void connect(ApduConnection apduConnection) throws Iso7816FourCardException, IOException {
        if (apduConnection == null) {
            throw new IllegalArgumentException("La conexion no puede ser nula");
        }
        long[] lArray = apduConnection.getTerminals(false);
        if (lArray.length < 1) {
            throw new NoReadersFoundException();
        }
        InvalidCardException invalidCardException = null;
        CardNotPresentException cardNotPresentException = null;
        for (long l : lArray) {
            byte[] byArray;
            apduConnection.setTerminal((int)l);
            try {
                byArray = apduConnection.reset();
            }
            catch (CardNotPresentException cardNotPresentException2) {
                cardNotPresentException = cardNotPresentException2;
                continue;
            }
            Atr atr = new Atr(byArray, ATR_MASK);
            if (!ATR.equals(atr)) {
                invalidCardException = new InvalidCardException(this.getCardName(), ATR, byArray);
                continue;
            }
            return;
        }
        if (invalidCardException != null) {
            throw invalidCardException;
        }
        if (cardNotPresentException != null) {
            throw cardNotPresentException;
        }
        throw new ApduConnectionException("No se ha podido conectar con ningun lector de tarjetas");
    }

    private void preloadCertificates() throws IOException, Iso7816FourCardException {
        CertificateFactory certificateFactory;
        this.selectMasterFile();
        Cdf cdf = new Cdf();
        try {
            cdf.setDerValue(this.selectFileByLocationAndRead(CDF_LOCATION));
        }
        catch (Exception exception) {
            throw new IOException("Error en la lectura del CDF: " + exception, exception);
        }
        try {
            certificateFactory = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException certificateException) {
            throw new IOException("Error obteniendo la factoria de certificados X.509: " + certificateException, certificateException);
        }
        for (int i = 0; i < cdf.getCertificateCount(); ++i) {
            try {
                certificatesByAlias.put(cdf.getCertificateAlias(i), (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(this.selectFileByLocationAndRead(new Location(cdf.getCertificatePath(i))))));
                continue;
            }
            catch (CertificateException certificateException) {
                throw new IOException("Error en la lectura del certificado " + i + " del dispositivo: " + certificateException, certificateException);
            }
        }
    }

    private void selectPkcs15Applet() throws ApduConnectionException, InvalidCardException {
        for (byte[] byArray : APPLETS_AIDS) {
            try {
                this.selectFileByName(byArray);
                return;
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
        }
        throw new InvalidCardException("La tarjeta no contiene ningun Applet PKCS#15 de identificador conocido");
    }

    private void loadKeyReferences() {
        PrKdf prKdf = new PrKdf();
        try {
            prKdf.setDerValue(this.selectFileByLocationAndRead(PRKDF_LOCATION));
        }
        catch (RequiredSecurityStateNotSatisfiedException requiredSecurityStateNotSatisfiedException) {
            throw new SecurityException("Se necesita PIN");
        }
        catch (Exception exception) {
            throw new IllegalStateException("No se ha podido cargar el PrKDF de la tarjeta: " + exception.toString());
        }
        System.out.println(prKdf.toString());
    }

    @Override
    public String[] getAliases() {
        return certificatesByAlias.keySet().toArray(new String[0]);
    }

    @Override
    public X509Certificate getCertificate(String string) {
        return certificatesByAlias.get(string);
    }

    @Override
    public PrivateKeyReference getPrivateKey(String string) throws CryptoCardException {
        ResponseApdu responseApdu;
        if (string == null) {
            throw new IllegalArgumentException("El alias no puede ser nulo");
        }
        if (!certificatesByAlias.containsKey(string)) {
            LOGGER.warning("La tarjeta no contiene el alias '" + string + "', se devolvera null");
            return null;
        }
        String[] stringArray = this.getAliases();
        byte by = -1;
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string.equals(stringArray[i])) continue;
            by = (byte)i;
            break;
        }
        if (by == -1) {
            throw new IllegalStateException("La tarjeta no contiene el alias: " + string);
        }
        MseSetSignatureKeyApduCommand mseSetSignatureKeyApduCommand = new MseSetSignatureKeyApduCommand(CLA, MseSetSignatureKeyApduCommand.CryptographicMechanism.RSASSA_PKCS1v1_5_SHA1, by);
        try {
            responseApdu = this.sendArbitraryApdu(mseSetSignatureKeyApduCommand);
        }
        catch (Exception exception) {
            throw new CryptoCardException("Error enviando la APDU de establecimiento de clave privada para firma: " + exception, exception);
        }
        if (responseApdu.isOk()) {
            return new TuiPrivateKeyReference(by);
        }
        throw new CryptoCardException("No se ha podido recuperar la referencia a la clave privada: " + HexUtils.hexify(responseApdu.getBytes(), true));
    }

    @Override
    public byte[] sign(byte[] byArray, String string, PrivateKeyReference privateKeyReference) throws CryptoCardException, BadPinException {
        if (privateKeyReference == null) {
            throw new IllegalArgumentException("La referencia a la clave privada no puede ser nula");
        }
        if (!(privateKeyReference instanceof TuiPrivateKeyReference)) {
            throw new CryptoCardException("Solo se admiten claves privadas de tipo TuiPrivateKeyReference, pero se encontro: " + privateKeyReference.getClass().getName());
        }
        return null;
    }

    @Override
    protected void selectMasterFile() throws ApduConnectionException, FileNotFoundException {
        CommandApdu commandApdu = new CommandApdu(CLA, -92, 8, 12, new byte[]{80, 0, 80, 1}, null);
        this.sendArbitraryApdu(commandApdu);
    }

    @Override
    public String getCardName() {
        return "Gemalto TUI R5 (MPCOS)";
    }

    private int getRemainingPinRetries() throws ApduConnectionException {
        CheckVerifyRetriesLeftApduCommand checkVerifyRetriesLeftApduCommand = new CheckVerifyRetriesLeftApduCommand(0);
        ResponseApdu responseApdu = this.getConnection().transmit(checkVerifyRetriesLeftApduCommand);
        if (responseApdu.getStatusWord().getMsb() == 99) {
            return responseApdu.getStatusWord().getLsb() - -64;
        }
        throw new ApduConnectionException("Respuesta desconocida: " + HexUtils.hexify(responseApdu.getBytes(), true));
    }

    @Override
    public void verifyPin(PasswordCallback passwordCallback) throws ApduConnectionException, BadPinException {
        VerifyApduCommand verifyApduCommand = new VerifyApduCommand(CLA, this.passwordCallback);
        ResponseApdu responseApdu = this.getConnection().transmit(verifyApduCommand);
        if (!responseApdu.isOk()) {
            throw new BadPinException(responseApdu.getStatusWord().getLsb() - -64);
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(this.getCardName()).append("\n Tarjeta con ").append(certificatesByAlias.size()).append(" certificado(s):\n");
        String[] stringArray = this.getAliases();
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuilder.append("  ");
            stringBuilder.append(i + 1);
            stringBuilder.append(" - ");
            stringBuilder.append(stringArray[i]);
        }
        return stringBuilder.toString();
    }
}

