/*
 * Decompiled with CFR 0.152.
 */
package es.gob.jmulticard.card.dnie;

import es.gob.jmulticard.CryptoHelper;
import es.gob.jmulticard.HexUtils;
import es.gob.jmulticard.apdu.CommandApdu;
import es.gob.jmulticard.apdu.ResponseApdu;
import es.gob.jmulticard.apdu.connection.ApduConnection;
import es.gob.jmulticard.apdu.connection.ApduConnectionException;
import es.gob.jmulticard.apdu.connection.CardNotPresentException;
import es.gob.jmulticard.apdu.connection.LostChannelException;
import es.gob.jmulticard.apdu.connection.NoReadersFoundException;
import es.gob.jmulticard.apdu.connection.cwa14890.Cwa14890OneConnection;
import es.gob.jmulticard.apdu.connection.cwa14890.SecureChannelException;
import es.gob.jmulticard.apdu.dnie.GetChipInfoApduCommand;
import es.gob.jmulticard.apdu.dnie.MseSetSignatureKeyApduCommand;
import es.gob.jmulticard.apdu.dnie.VerifyApduCommand;
import es.gob.jmulticard.apdu.iso7816eight.PsoSignHashApduCommand;
import es.gob.jmulticard.apdu.iso7816four.ExternalAuthenticateApduCommand;
import es.gob.jmulticard.apdu.iso7816four.InternalAuthenticateApduCommand;
import es.gob.jmulticard.apdu.iso7816four.MseSetAuthenticationKeyApduCommand;
import es.gob.jmulticard.asn1.der.pkcs1.DigestInfo;
import es.gob.jmulticard.asn1.der.pkcs15.Cdf;
import es.gob.jmulticard.asn1.der.pkcs15.PrKdf;
import es.gob.jmulticard.card.Atr;
import es.gob.jmulticard.card.AuthenticationModeLockedException;
import es.gob.jmulticard.card.BadPinException;
import es.gob.jmulticard.card.CryptoCard;
import es.gob.jmulticard.card.CryptoCardException;
import es.gob.jmulticard.card.InvalidCardException;
import es.gob.jmulticard.card.Location;
import es.gob.jmulticard.card.PrivateKeyReference;
import es.gob.jmulticard.card.cwa14890.Cwa14890Card;
import es.gob.jmulticard.card.dnie.BurnedDnieCardException;
import es.gob.jmulticard.card.dnie.DnieCardException;
import es.gob.jmulticard.card.dnie.DnieCwa14890Constants;
import es.gob.jmulticard.card.dnie.DniePrivateKeyReference;
import es.gob.jmulticard.card.iso7816eight.Iso7816EightCard;
import es.gob.jmulticard.card.iso7816four.FileNotFoundException;
import es.gob.jmulticard.card.iso7816four.Iso7816FourCardException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateKey;
import java.util.logging.Logger;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import javax.security.auth.callback.PasswordCallback;

public final class Dnie
extends Iso7816EightCard
implements CryptoCard,
Cwa14890Card {
    private static final boolean SHOW_SIGN_CONFIRM_DIALOG = true;
    private static final byte ERROR_PIN_SW1 = 99;
    private static final boolean PIN_AUTO_RETRY = true;
    private static final byte[] CERT_ICC_FILE_ID = new byte[]{96, 31};
    private static final String MASTER_FILE_NAME = "Master.File";
    private static final String AUTH_CERT_ALIAS = "CertAutenticacion";
    private static final String SIGN_CERT_ALIAS = "CertFirmaDigital";
    private static final String INTERMEDIATE_CA_CERT_ALIAS = "CertCAIntermediaDGP";
    private static final String AUTH_KEY_LABEL = "KprivAutenticacion";
    private static final String SIGN_KEY_LABEL = "KprivFirmaDigital";
    private static final Location CDF_LOCATION = new Location("50156004");
    private static final Location PRKDF_LOCATION = new Location("50156001");
    private X509Certificate authCert;
    private X509Certificate signCert;
    private X509Certificate intermediateCaCert;
    private Location authCertPath;
    private Location signCertPath;
    private DniePrivateKeyReference authKeyRef;
    private DniePrivateKeyReference signKeyRef;
    private CryptoHelper cryptoHelper = null;
    private static final byte[] ATR_MASK = new byte[]{-1, -1, 0, -1, -1, -1, -1, -1, -1, -1, -1, 0, 0, 0, 0, 0, 0, 0, -1, -1};
    private static final Atr ATR = new Atr(new byte[]{59, 127, 0, 0, 0, 0, 106, 68, 78, 73, 101, 0, 0, 0, 0, 0, 0, 0, -112, 0}, ATR_MASK);
    private final PasswordCallback passwordCallback;

    private void connect(ApduConnection apduConnection) throws BurnedDnieCardException, InvalidCardException, ApduConnectionException {
        if (apduConnection == null) {
            throw new IllegalArgumentException("La conexion no puede ser nula");
        }
        InvalidCardException invalidCardException = null;
        CardNotPresentException cardNotPresentException = null;
        long[] lArray = apduConnection.getTerminals(false);
        if (lArray.length < 1) {
            throw new NoReadersFoundException();
        }
        for (long l : lArray) {
            byte[] byArray;
            apduConnection.setTerminal((int)l);
            try {
                byArray = apduConnection.reset();
            }
            catch (CardNotPresentException cardNotPresentException2) {
                cardNotPresentException = cardNotPresentException2;
                continue;
            }
            Atr atr = new Atr(byArray, ATR_MASK);
            if (!ATR.equals(atr)) {
                byte[] byArray2 = atr.getBytes();
                if (byArray2[byArray2.length - 1] == -127 && byArray2[byArray2.length - 2] == 101) {
                    throw new BurnedDnieCardException(atr);
                }
                invalidCardException = new InvalidCardException(this.getCardName(), ATR, byArray);
                continue;
            }
            return;
        }
        if (invalidCardException != null) {
            throw invalidCardException;
        }
        if (cardNotPresentException != null) {
            throw cardNotPresentException;
        }
        throw new ApduConnectionException("No se ha podido conectar con ningun lector de tarjetas");
    }

    public Dnie(ApduConnection apduConnection, PasswordCallback passwordCallback, CryptoHelper cryptoHelper) throws ApduConnectionException, InvalidCardException, BurnedDnieCardException {
        super((byte)0, apduConnection);
        this.connect(apduConnection);
        this.passwordCallback = passwordCallback;
        if (cryptoHelper == null) {
            throw new IllegalArgumentException("El CryptoHelper no puede ser nula");
        }
        this.cryptoHelper = cryptoHelper;
        this.preloadCertificates();
        this.loadKeyReferences();
    }

    private void loadKeyReferences() {
        PrKdf prKdf = new PrKdf();
        try {
            prKdf.setDerValue(this.selectFileByLocationAndRead(PRKDF_LOCATION));
        }
        catch (Exception exception) {
            throw new IllegalStateException("No se ha podido cargar el PrKDF de la tarjeta: " + exception.toString());
        }
        for (int i = 0; i < prKdf.getKeyCount(); ++i) {
            if (AUTH_KEY_LABEL.equals(prKdf.getKeyName(i))) {
                this.authKeyRef = new DniePrivateKeyReference(this, prKdf.getKeyIdentifier(i), new Location(prKdf.getKeyPath(i)), AUTH_KEY_LABEL);
                continue;
            }
            if (!SIGN_KEY_LABEL.equals(prKdf.getKeyName(i))) continue;
            this.signKeyRef = new DniePrivateKeyReference(this, prKdf.getKeyIdentifier(i), new Location(prKdf.getKeyPath(i)), SIGN_KEY_LABEL);
        }
    }

    @Override
    public byte[] getSerialNumber() throws ApduConnectionException {
        ResponseApdu responseApdu = this.getConnection().transmit(new GetChipInfoApduCommand());
        if (responseApdu.isOk()) {
            return responseApdu.getData();
        }
        throw new ApduConnectionException("Respuesta invalida en la obtencion del numero de serie con el codigo: " + responseApdu.getStatusWord());
    }

    @Override
    public String getCardName() {
        return "DNIe";
    }

    @Override
    public String[] getAliases() {
        return new String[]{AUTH_CERT_ALIAS, SIGN_CERT_ALIAS};
    }

    private void preloadCertificates() {
        Cdf cdf = new Cdf();
        try {
            this.selectMasterFile();
            cdf.setDerValue(this.selectFileByLocationAndRead(CDF_LOCATION));
        }
        catch (Exception exception) {
            throw new IllegalStateException("No se ha podido cargar el CDF de la tarjeta: " + exception.toString());
        }
        for (int i = 0; i < cdf.getCertificateCount(); ++i) {
            if (AUTH_CERT_ALIAS.equals(cdf.getCertificateAlias(i))) {
                this.authCertPath = new Location(cdf.getCertificatePath(i));
                continue;
            }
            if (SIGN_CERT_ALIAS.equals(cdf.getCertificateAlias(i))) {
                this.signCertPath = new Location(cdf.getCertificatePath(i));
                continue;
            }
            try {
                byte[] byArray = Dnie.deflate(this.selectFileByLocationAndRead(new Location(cdf.getCertificatePath(i))));
                this.intermediateCaCert = (X509Certificate)CertificateFactory.getInstance("X.509").generateCertificate(new ByteArrayInputStream(byArray));
                continue;
            }
            catch (Exception exception) {
                Logger.getLogger("es.gob.jmulticard").warning("No se ha podido cargar el certificado de la autoridad intermedia de la DGP: " + exception.toString());
                this.intermediateCaCert = null;
            }
        }
    }

    private void loadCertificates() throws CryptoCardException, BadPinException {
        if (this.isSecurityChannelOpen()) {
            return;
        }
        this.verifyAndLoadCertificates();
    }

    @Override
    public X509Certificate getCertificate(String string) throws CryptoCardException, BadPinException {
        if (this.authCert == null) {
            this.loadCertificates();
        }
        if (AUTH_CERT_ALIAS.equals(string)) {
            return this.authCert;
        }
        if (SIGN_CERT_ALIAS.equals(string)) {
            return this.signCert;
        }
        if (INTERMEDIATE_CA_CERT_ALIAS.equals(string)) {
            return this.intermediateCaCert;
        }
        return null;
    }

    @Override
    public void verifyCaIntermediateIcc() throws CertificateException, IOException {
    }

    @Override
    public void verifyIcc() throws CertificateException, IOException {
    }

    @Override
    public byte[] getIccCertEncoded() throws IOException {
        byte[] byArray;
        try {
            this.selectMasterFile();
            byArray = this.selectFileByIdAndRead(CERT_ICC_FILE_ID);
        }
        catch (ApduConnectionException apduConnectionException) {
            throw new IOException("Error en el envio de APDU para la seleccion del certificado de componente de la tarjeta: " + apduConnectionException, apduConnectionException);
        }
        catch (Iso7816FourCardException iso7816FourCardException) {
            throw new IOException("Error en la seleccion del certificado de componente de la tarjeta: " + iso7816FourCardException, iso7816FourCardException);
        }
        return byArray;
    }

    @Override
    public void verifyIfdCertificateChain() throws ApduConnectionException {
        try {
            this.setPublicKeyToVerification(DnieCwa14890Constants.REF_C_CV_CA_PUBLIC_KEY);
        }
        catch (SecureChannelException secureChannelException) {
            throw new SecureChannelException("Error al seleccionar para verificacion la clave publica de la CA raiz de los certificados verificables por la tarjeta", secureChannelException);
        }
        try {
            this.verifyCertificate(DnieCwa14890Constants.C_CV_CA);
        }
        catch (SecureChannelException secureChannelException) {
            throw new SecureChannelException("Error en la verificacion del certificado de la CA intermedia de Terminal", secureChannelException);
        }
        try {
            this.setPublicKeyToVerification(DnieCwa14890Constants.CHR_C_CV_CA);
        }
        catch (SecureChannelException secureChannelException) {
            throw new SecureChannelException("Error al establecer la clave publica del certificado de CA intermedia de Terminal para su verificacion en tarjeta", secureChannelException);
        }
        try {
            this.verifyCertificate(DnieCwa14890Constants.C_CV_IFD);
        }
        catch (SecureChannelException secureChannelException) {
            throw new SecureChannelException("Error en la verificacion del certificado de Terminal", secureChannelException);
        }
    }

    @Override
    public byte[] getRefIccPrivateKey() {
        return DnieCwa14890Constants.REF_ICC_PRIVATE_KEY;
    }

    @Override
    public byte[] getChrCCvIfd() {
        return DnieCwa14890Constants.CHR_C_CV_IFD;
    }

    @Override
    public RSAPrivateKey getIfdPrivateKey() {
        return DnieCwa14890Constants.IFD_PRIVATE_KEY;
    }

    @Override
    public void setKeysToAuthentication(byte[] byArray, byte[] byArray2) throws ApduConnectionException {
        MseSetAuthenticationKeyApduCommand mseSetAuthenticationKeyApduCommand = new MseSetAuthenticationKeyApduCommand(0, byArray, byArray2);
        ResponseApdu responseApdu = this.getConnection().transmit(mseSetAuthenticationKeyApduCommand);
        if (!responseApdu.isOk()) {
            throw new SecureChannelException("Error durante el establecimiento de las claves publica y privada para atenticacion (error: " + HexUtils.hexify(responseApdu.getBytes(), true) + ")");
        }
    }

    @Override
    public byte[] getInternalAuthenticateMessage(byte[] byArray, byte[] byArray2) throws ApduConnectionException {
        InternalAuthenticateApduCommand internalAuthenticateApduCommand = new InternalAuthenticateApduCommand(0, byArray, byArray2);
        ResponseApdu responseApdu = this.getConnection().transmit(internalAuthenticateApduCommand);
        if (responseApdu.isOk()) {
            return responseApdu.getData();
        }
        throw new ApduConnectionException("Respuesta invalida en la obtencion del mensaje de autenticacion interna con el codigo: " + responseApdu.getStatusWord());
    }

    @Override
    public boolean externalAuthentication(byte[] byArray) throws ApduConnectionException {
        ExternalAuthenticateApduCommand externalAuthenticateApduCommand = new ExternalAuthenticateApduCommand(0, byArray);
        return this.getConnection().transmit(externalAuthenticateApduCommand).isOk();
    }

    @Override
    public PrivateKeyReference getPrivateKey(String string) {
        if (AUTH_CERT_ALIAS.equals(string)) {
            return this.authKeyRef;
        }
        if (SIGN_CERT_ALIAS.equals(string)) {
            return this.signKeyRef;
        }
        return null;
    }

    @Override
    public byte[] sign(byte[] byArray, String string, PrivateKeyReference privateKeyReference) throws CryptoCardException, BadPinException {
        boolean bl;
        Executable executable;
        Class<?> clazz;
        Serializable serializable;
        if (!(privateKeyReference instanceof DniePrivateKeyReference)) {
            throw new IllegalArgumentException("La referencia a la clave privada tiene que ser de tipo DniePrivateKeyReference");
        }
        try {
            serializable = Class.forName("es.gob.jmulticard.ui.passwordcallback.DialogBuilder");
            clazz = Class.forName("java.awt.Component");
            executable = serializable.getMethod("showSignatureConfirmDialog", clazz, Boolean.TYPE);
            Integer n = (Integer)((Method)executable).invoke(null, null, !AUTH_KEY_LABEL.equals(((DniePrivateKeyReference)privateKeyReference).toString()));
            bl = n == 1;
        }
        catch (Exception exception) {
            Logger.getLogger("es.gob.afirma").severe("No se ha podido mostrar el dialogo grafico para la autorizacion de la firma, se realizara sin aprobacion expresa: " + exception);
            bl = false;
        }
        if (bl) {
            try {
                clazz = Class.forName("es.gob.jmulticard.ui.passwordcallback.CancelledOperationException");
                executable = clazz.getConstructor(String.class);
                serializable = (RuntimeException)((Constructor)executable).newInstance("Operacion de firma no autorizada por el usuario");
            }
            catch (Exception exception) {
                throw new IllegalArgumentException("No se ha instanciar CancelledOperationException", exception);
            }
            throw serializable;
        }
        return this.signOperation(byArray, string, privateKeyReference);
    }

    private byte[] signOperation(byte[] byArray, String string, PrivateKeyReference privateKeyReference) throws CryptoCardException, BadPinException {
        ResponseApdu responseApdu;
        if (!this.isSecurityChannelOpen()) {
            this.verifyAndLoadCertificates();
        }
        try {
            byte[] byArray2;
            CommandApdu commandApdu = new MseSetSignatureKeyApduCommand(0, ((DniePrivateKeyReference)privateKeyReference).getKeyPath().getLastFilePath());
            responseApdu = this.getConnection().transmit(commandApdu);
            if (!responseApdu.isOk()) {
                throw new DnieCardException("Error en el establecimiento de las variables de entorno para firma", responseApdu.getStatusWord());
            }
            try {
                byArray2 = DigestInfo.encode(string, byArray, this.cryptoHelper);
            }
            catch (IOException iOException) {
                throw new DnieCardException("Error en el calculo del hash para firmar", iOException);
            }
            commandApdu = new PsoSignHashApduCommand(0, byArray2);
            responseApdu = this.getConnection().transmit(commandApdu);
            if (!responseApdu.isOk()) {
                throw new DnieCardException("Error durante la operacion de firma", responseApdu.getStatusWord());
            }
        }
        catch (LostChannelException lostChannelException) {
            try {
                this.getConnection().close();
                if (this.getConnection() instanceof Cwa14890OneConnection) {
                    this.setConnection(((Cwa14890OneConnection)this.getConnection()).getSubConnection());
                }
            }
            catch (Exception exception) {
                throw new DnieCardException("No se pudo recuperar el canal seguro para firmar: " + exception, exception);
            }
            return this.signOperation(byArray, string, privateKeyReference);
        }
        catch (ApduConnectionException apduConnectionException) {
            throw new DnieCardException("Error en la transmision de comandos a la tarjeta", apduConnectionException);
        }
        return responseApdu.getData();
    }

    private void verifyAndLoadCertificates() throws CryptoCardException, BadPinException {
        Object object;
        if (!this.isSecurityChannelOpen()) {
            if (!(this.getConnection() instanceof Cwa14890OneConnection)) {
                object = new Cwa14890OneConnection(this, this.getConnection(), this.cryptoHelper);
                try {
                    this.setConnection((ApduConnection)object);
                }
                catch (ApduConnectionException apduConnectionException) {
                    throw new CryptoCardException("Error en el establecimiento del canal seguro", apduConnectionException);
                }
            }
            try {
                this.verifyPin(this.passwordCallback);
                if (this.passwordCallback != null) {
                    this.passwordCallback.clearPassword();
                }
            }
            catch (ApduConnectionException apduConnectionException) {
                throw new CryptoCardException("Error en la apertura del canal seguro: " + apduConnectionException, apduConnectionException);
            }
        }
        try {
            object = CertificateFactory.getInstance("X.509");
            byte[] byArray = Dnie.deflate(this.selectFileByLocationAndRead(this.authCertPath));
            this.authCert = (X509Certificate)((CertificateFactory)object).generateCertificate(new ByteArrayInputStream(byArray));
            byte[] byArray2 = Dnie.deflate(this.selectFileByLocationAndRead(this.signCertPath));
            this.signCert = (X509Certificate)((CertificateFactory)object).generateCertificate(new ByteArrayInputStream(byArray2));
        }
        catch (CertificateException certificateException) {
            throw new CryptoCardException("Error al cargar los certificados reales del DNIe, no es posible obtener una factoria de certificados X.509", certificateException);
        }
        catch (IOException iOException) {
            throw new CryptoCardException("Error al cargar los certificados reales del DNIe, error en la descompresion de los datos", iOException);
        }
        catch (Iso7816FourCardException iso7816FourCardException) {
            throw new CryptoCardException("Error al cargar los certificados reales del DNIe, no es posible obtener una factoria de certificados X.509", iso7816FourCardException);
        }
    }

    @Override
    protected void selectMasterFile() throws ApduConnectionException, FileNotFoundException {
        this.selectFileByName(MASTER_FILE_NAME);
    }

    private static byte[] deflate(byte[] byArray) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Inflater inflater = new Inflater();
        inflater.setInput(byArray, 8, byArray.length - 8);
        byte[] byArray2 = new byte[1024];
        try {
            while (!inflater.finished()) {
                int n = inflater.inflate(byArray2);
                if (n == 0) {
                    throw new DataFormatException();
                }
                byteArrayOutputStream.write(byArray2, 0, n);
            }
            return byteArrayOutputStream.toByteArray();
        }
        catch (DataFormatException dataFormatException) {
            throw new IOException("Error al descomprimir el certificado: " + dataFormatException, dataFormatException);
        }
    }

    private boolean isSecurityChannelOpen() {
        return this.getConnection() instanceof Cwa14890OneConnection && this.getConnection().isOpen();
    }

    @Override
    public void verifyPin(PasswordCallback passwordCallback) throws ApduConnectionException, BadPinException {
        this.verifyPin(passwordCallback, Integer.MAX_VALUE);
    }

    private void verifyPin(PasswordCallback passwordCallback, int n) throws ApduConnectionException, BadPinException {
        Object object;
        Object object2;
        PasswordCallback passwordCallback2 = null;
        try {
            if (passwordCallback != null) {
                passwordCallback2 = passwordCallback;
            } else if (n < Integer.MAX_VALUE) {
                object2 = Class.forName("es.gob.jmulticard.ui.passwordcallback.gui.CommonPasswordCallback");
                object = ((Class)object2).getMethod("getDnieBadPinPasswordCallback", Integer.TYPE);
                passwordCallback2 = (PasswordCallback)((Method)object).invoke(null, n);
            } else {
                object2 = Class.forName("es.gob.jmulticard.ui.passwordcallback.gui.CommonPasswordCallback");
                object = ((Class)object2).getMethod("getDniePinForCertificateReadingPasswordCallback", new Class[0]);
                passwordCallback2 = (PasswordCallback)((Method)object).invoke(null, new Object[0]);
            }
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("pinPc no puede ser nulo cuando no hay un PasswordCallback por defecto", exception);
        }
        object2 = new VerifyApduCommand(0, passwordCallback2);
        object = this.getConnection().transmit((CommandApdu)object2);
        object2 = null;
        passwordCallback2.clearPassword();
        if (!((ResponseApdu)object).isOk()) {
            if (((ResponseApdu)object).getStatusWord().getMsb() == 99) {
                this.verifyPin(passwordCallback, ((ResponseApdu)object).getStatusWord().getLsb() - -64);
            } else if (((ResponseApdu)object).getStatusWord().getMsb() == 105 && ((ResponseApdu)object).getStatusWord().getLsb() == -125) {
                throw new AuthenticationModeLockedException();
            }
        }
    }
}

