/*
 * Decompiled with CFR 0.152.
 */
package es.gob.jmulticard.card;

import es.gob.jmulticard.apdu.CommandApdu;
import es.gob.jmulticard.apdu.ResponseApdu;
import es.gob.jmulticard.apdu.connection.ApduConnection;
import es.gob.jmulticard.apdu.connection.ApduConnectionException;
import es.gob.jmulticard.card.Card;

public abstract class SmartCard
implements Card {
    private final byte cla;
    private ApduConnection connection;

    protected ApduConnection getConnection() {
        return this.connection;
    }

    protected ResponseApdu sendArbitraryApdu(CommandApdu commandApdu) throws ApduConnectionException {
        return this.connection.transmit(commandApdu);
    }

    protected void setConnection(ApduConnection apduConnection) throws ApduConnectionException {
        this.connection.close();
        if (!apduConnection.isOpen()) {
            apduConnection.open();
        }
        this.connection = apduConnection;
    }

    protected byte getCla() {
        return this.cla;
    }

    public SmartCard(byte by, ApduConnection apduConnection) throws ApduConnectionException {
        if (apduConnection == null) {
            throw new IllegalArgumentException("La conexion con la tarjeta no puede ser nula");
        }
        this.cla = by;
        this.connection = apduConnection;
    }

    public abstract String getCardName();
}

