/*
 * Decompiled with CFR 0.152.
 */
package es.gob.jmulticard.card;

import es.gob.jmulticard.HexUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

public final class Location {
    private static final int MASTER_FILE_ID = 16128;
    private Vector<Integer> path = new Vector();
    private static final Map<String, Integer> HEXBYTES;

    public Location(String string) {
        this.init(string);
    }

    public Location(String string, char c) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == c) continue;
            stringBuffer.append(string.charAt(i));
        }
        this.init(stringBuffer.toString());
    }

    private Location(Vector<Integer> vector) {
        if (vector != null) {
            int n = vector.size();
            this.path = new Vector(n);
            for (int i = 0; i < n; ++i) {
                this.path.insertElementAt(vector.elementAt(i), i);
            }
        }
    }

    public Location getChild() {
        Location location = new Location(this.path);
        if (location.path != null && location.path.size() > 1) {
            location.path.removeElementAt(0);
            return location;
        }
        return null;
    }

    public byte[] getFile() {
        int n = this.path.elementAt(0);
        return new byte[]{(byte)(n >> 8 & 0xFF), (byte)(n & 0xFF)};
    }

    public byte[] getLastFilePath() {
        if (this.path.size() < 1) {
            return null;
        }
        int n = this.path.elementAt(this.path.size() - 1);
        return new byte[]{(byte)(n >> 8 & 0xFF), (byte)(n & 0xFF)};
    }

    private static boolean isValidPath(String string) {
        if (string.length() == 0) {
            return false;
        }
        String string2 = string.toLowerCase();
        for (int i = 0; i < string.length(); ++i) {
            if (string2.charAt(i) >= '0' && string2.charAt(i) <= '9' || string2.charAt(i) >= 'a' && string2.charAt(i) <= 'f') continue;
            return false;
        }
        return true;
    }

    private void init(String string) {
        if (string == null || "".equals(string.trim()) || string.trim().length() % 4 != 0) {
            throw new IllegalArgumentException("Un location valido debe estar compuesto por grupos de pares octetos.");
        }
        if (!Location.isValidPath(string)) {
            throw new IllegalArgumentException("La ruta contiene caracteres no validos.");
        }
        for (int i = 0; i < string.length(); i += 4) {
            int n;
            int n2 = HEXBYTES.get(string.substring(i, i + 1));
            int n3 = HEXBYTES.get(string.substring(i + 1, i + 2));
            int n4 = HEXBYTES.get(string.substring(i + 2, i + 3));
            int n5 = n = HEXBYTES.get(string.substring(i + 3, i + 4)).intValue();
            n5 += n4 << 4;
            n5 += n3 << 8;
            if ((n5 += n2 << 4 << 8) == 16128) continue;
            this.path.addElement(Integer.valueOf(String.valueOf(n5)));
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.path != null && !this.path.isEmpty()) {
            stringBuffer.append("3F00");
            for (int i = 0; i < this.path.size(); ++i) {
                Integer n = this.path.elementAt(i);
                stringBuffer.append('/').append(HexUtils.hexify(new byte[]{(byte)(n.shortValue() >> 8), n.byteValue()}, false));
            }
        }
        return stringBuffer.toString();
    }

    static {
        int n;
        HEXBYTES = new HashMap<String, Integer>();
        String[] stringArray = new String[]{"a", "b", "c", "d", "e", "f"};
        for (n = 0; n < 9; ++n) {
            HEXBYTES.put(String.valueOf(n), Integer.valueOf(String.valueOf(n)));
        }
        for (n = 10; n < 16; ++n) {
            HEXBYTES.put(stringArray[n - 10], Integer.valueOf(String.valueOf(n)));
            HEXBYTES.put(stringArray[n - 10].toUpperCase(), Integer.valueOf(String.valueOf(n)));
        }
    }
}

