/*
 * Decompiled with CFR 0.152.
 */
package es.gob.jmulticard.card;

import es.gob.jmulticard.HexUtils;
import es.gob.jmulticard.card.Atr;
import es.gob.jmulticard.card.CardException;

public final class InvalidCardException
extends CardException {
    private static final long serialVersionUID = 4888120866657775782L;
    private final Atr atr;
    private final String name;
    private final byte[] badAtr;

    public InvalidCardException(String string) {
        super(string);
        this.name = null;
        this.badAtr = null;
        this.atr = null;
    }

    public InvalidCardException(String string, Atr atr, byte[] byArray) {
        super("Se esperaba una tarjeta de tipo '" + string + "' pero se encontro otra con ATR=" + (byArray == null ? "NULO" : HexUtils.hexify(byArray, true)));
        this.atr = atr;
        this.name = string;
        if (byArray != null) {
            this.badAtr = new byte[byArray.length];
            System.arraycopy(byArray, 0, this.badAtr, 0, this.badAtr.length);
        } else {
            this.badAtr = null;
        }
    }

    public Atr getExpectedAtr() {
        return this.atr;
    }

    public String getExpectedCardName() {
        return this.name;
    }

    public byte[] getFoundAtr() {
        if (this.badAtr == null) {
            return null;
        }
        byte[] byArray = new byte[this.badAtr.length];
        System.arraycopy(this.badAtr, 0, byArray, 0, this.badAtr.length);
        return byArray;
    }
}

