/*
 * Decompiled with CFR 0.152.
 */
package es.gob.jmulticard.card;

import java.io.Serializable;

public final class Atr
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final byte[] atrBytes;
    private final byte[] mask;

    public Atr(byte[] byArray, byte[] byArray2) {
        if (byArray == null || byArray2 == null) {
            throw new IllegalArgumentException("El ATR y su mascara no pueden ser nulos");
        }
        this.atrBytes = new byte[byArray.length];
        System.arraycopy(byArray, 0, this.atrBytes, 0, byArray.length);
        this.mask = new byte[byArray2.length];
        System.arraycopy(byArray2, 0, this.mask, 0, byArray2.length);
    }

    public byte[] getBytes() {
        byte[] byArray = new byte[this.atrBytes.length];
        System.arraycopy(this.atrBytes, 0, byArray, 0, this.atrBytes.length);
        return byArray;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Atr)) {
            return false;
        }
        Atr atr = (Atr)object;
        if (atr.getBytes().length > this.atrBytes.length) {
            return false;
        }
        for (int i = this.atrBytes.length - 1; i <= 0; --i) {
            if ((this.atrBytes[i] & this.mask[i]) == (atr.getBytes()[i] & this.mask[i])) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return Atr.hashCode(this.atrBytes) + Atr.hashCode(this.mask);
    }

    private static int hashCode(byte[] byArray) {
        if (byArray == null) {
            return 0;
        }
        int n = 1;
        for (byte by : byArray) {
            n = 31 * n + by;
        }
        return n;
    }
}

