/*
 * Decompiled with CFR 0.152.
 */
package es.gob.jmulticard.asn1.der.pkcs15;

import es.gob.jmulticard.HexUtils;
import es.gob.jmulticard.asn1.OptionalDecoderObjectElement;
import es.gob.jmulticard.asn1.der.Record;
import es.gob.jmulticard.asn1.der.pkcs15.CertificateObject;
import java.math.BigInteger;

public final class Cdf
extends Record {
    private static final int BUFFER_SIZE = 150;

    public Cdf() {
        super(new OptionalDecoderObjectElement[]{new OptionalDecoderObjectElement(CertificateObject.class, false), new OptionalDecoderObjectElement(CertificateObject.class, true), new OptionalDecoderObjectElement(CertificateObject.class, true), new OptionalDecoderObjectElement(CertificateObject.class, true), new OptionalDecoderObjectElement(CertificateObject.class, true), new OptionalDecoderObjectElement(CertificateObject.class, true), new OptionalDecoderObjectElement(CertificateObject.class, true), new OptionalDecoderObjectElement(CertificateObject.class, true), new OptionalDecoderObjectElement(CertificateObject.class, true), new OptionalDecoderObjectElement(CertificateObject.class, true)});
    }

    public int getCertificateCount() {
        return this.getElementCount();
    }

    public String getCertificateIssuerPrincipal(int n) {
        CertificateObject certificateObject = (CertificateObject)this.getElementAt(n);
        if (certificateObject != null) {
            return certificateObject.getIssuer();
        }
        return null;
    }

    public String getCertificateSubjectPrincipal(int n) {
        CertificateObject certificateObject = (CertificateObject)this.getElementAt(n);
        if (certificateObject != null) {
            return certificateObject.getSubject();
        }
        return null;
    }

    public BigInteger getCertificateSerialNumber(int n) {
        CertificateObject certificateObject = (CertificateObject)this.getElementAt(n);
        if (certificateObject != null) {
            return certificateObject.getSerialNumber();
        }
        return null;
    }

    public byte[] getCertificateIdentifier(int n) {
        CertificateObject certificateObject = (CertificateObject)this.getElementAt(n);
        if (certificateObject != null) {
            return certificateObject.getIdentifier();
        }
        return null;
    }

    public String getCertificatePath(int n) {
        CertificateObject certificateObject = (CertificateObject)this.getElementAt(n);
        if (certificateObject != null) {
            return certificateObject.getPath();
        }
        return null;
    }

    public String getCertificateAlias(int n) {
        CertificateObject certificateObject = (CertificateObject)this.getElementAt(n);
        if (certificateObject != null) {
            return certificateObject.getAlias();
        }
        return null;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(150);
        stringBuffer.append("Fichero de Descripcion de Certificados:\n");
        for (int i = 0; i < this.getCertificateCount(); ++i) {
            stringBuffer.append(" Certificado ");
            stringBuffer.append(Integer.toString(i));
            stringBuffer.append("\n  Alias: ");
            stringBuffer.append(this.getCertificateAlias(i));
            stringBuffer.append("\n  Titular: ");
            stringBuffer.append(this.getCertificateSubjectPrincipal(i));
            stringBuffer.append("\n  Emisor: ");
            stringBuffer.append(this.getCertificateIssuerPrincipal(i));
            stringBuffer.append("\n  Numero de serie: ");
            stringBuffer.append(this.getCertificateSerialNumber(i));
            stringBuffer.append("\n  Identificador: ");
            stringBuffer.append(HexUtils.hexify(this.getCertificateIdentifier(i), true));
            stringBuffer.append("\n  Ruta PKCS#15: ");
            stringBuffer.append(this.getCertificatePath(i));
            stringBuffer.append('\n');
        }
        return stringBuffer.toString();
    }
}

