/*
 * Decompiled with CFR 0.152.
 */
package es.gob.jmulticard.asn1.der.pkcs1;

import es.gob.jmulticard.CryptoHelper;
import es.gob.jmulticard.asn1.OptionalDecoderObjectElement;
import es.gob.jmulticard.asn1.der.OctectString;
import es.gob.jmulticard.asn1.der.Sequence;
import es.gob.jmulticard.asn1.der.pkcs1.AlgorithmIdentifer;
import java.io.IOException;

public final class DigestInfo
extends Sequence {
    private static final String SHA1_NORMALIZED_ALGO_NAME = "SHA-1";
    private static final String SHA256_NORMALIZED_ALGO_NAME = "SHA-256";
    private static final String SHA384_NORMALIZED_ALGO_NAME = "SHA-384";
    private static final String SHA512_NORMALIZED_ALGO_NAME = "SHA-512";
    private static final String SHA1WITHRSA_NORMALIZED_ALGO_NAME = "SHA1withRSA";
    private static final String SHA256WITHRSA_NORMALIZED_ALGO_NAME = "SHA256withRSA";
    private static final String SHA384WITHRSA_NORMALIZED_ALGO_NAME = "SHA384withRSA";
    private static final String SHA512WITHRSA_NORMALIZED_ALGO_NAME = "SHA512withRSA";
    private static final byte[] SHA1_DIGESTINFO_HEADER = new byte[]{48, 33, 48, 9, 6, 5, 43, 14, 3, 2, 26, 5, 0, 4, 20};
    private static final byte[] SHA256_DIGESTINFO_HEADER = new byte[]{48, 49, 48, 13, 6, 9, 96, -122, 72, 1, 101, 3, 4, 2, 1, 5, 0, 4, 32};
    private static final byte[] SHA384_DIGESTINFO_HEADER = new byte[]{48, 65, 48, 13, 6, 9, 96, -122, 72, 1, 101, 3, 4, 2, 2, 5, 0, 4, 48};
    private static final byte[] SHA512_DIGESTINFO_HEADER = new byte[]{48, 81, 48, 13, 6, 9, 96, -122, 72, 1, 101, 3, 4, 2, 3, 5, 0, 4, 64};

    protected static byte[] getSha1DigestinfoHeader() {
        byte[] byArray = new byte[SHA1_DIGESTINFO_HEADER.length];
        System.arraycopy(SHA1_DIGESTINFO_HEADER, 0, byArray, 0, SHA1_DIGESTINFO_HEADER.length);
        return byArray;
    }

    protected static byte[] getSha256DigestinfoHeader() {
        byte[] byArray = new byte[SHA256_DIGESTINFO_HEADER.length];
        System.arraycopy(SHA256_DIGESTINFO_HEADER, 0, byArray, 0, SHA256_DIGESTINFO_HEADER.length);
        return byArray;
    }

    protected static byte[] getSha384DigestinfoHeader() {
        byte[] byArray = new byte[SHA384_DIGESTINFO_HEADER.length];
        System.arraycopy(SHA384_DIGESTINFO_HEADER, 0, byArray, 0, SHA384_DIGESTINFO_HEADER.length);
        return byArray;
    }

    protected static byte[] getSha512DigestinfoHeader() {
        byte[] byArray = new byte[SHA512_DIGESTINFO_HEADER.length];
        System.arraycopy(SHA512_DIGESTINFO_HEADER, 0, byArray, 0, SHA512_DIGESTINFO_HEADER.length);
        return byArray;
    }

    public DigestInfo() {
        super(new OptionalDecoderObjectElement[]{new OptionalDecoderObjectElement(AlgorithmIdentifer.class, false), new OptionalDecoderObjectElement(OctectString.class, false)});
    }

    public static byte[] encode(String string, byte[] byArray, CryptoHelper cryptoHelper) throws IOException {
        String string2 = DigestInfo.getNormalizedSigningAlgorithm(string);
        String string3 = DigestInfo.getDigestAlgorithm(string2);
        byte[] byArray2 = DigestInfo.selectHeaderTemplate(string3);
        byte[] byArray3 = cryptoHelper.digest(string3, byArray);
        byte[] byArray4 = new byte[byArray2.length + byArray3.length];
        System.arraycopy(byArray2, 0, byArray4, 0, byArray2.length);
        System.arraycopy(byArray3, 0, byArray4, byArray2.length, byArray3.length);
        return byArray4;
    }

    private static String getNormalizedSigningAlgorithm(String string) {
        if (SHA1WITHRSA_NORMALIZED_ALGO_NAME.equalsIgnoreCase(string) || "SHAwithRSA".equalsIgnoreCase(string) || "SHA-1withRSA".equalsIgnoreCase(string) || "SHA1withRSAEncryption".equalsIgnoreCase(string) || "SHA-1withRSAEncryption".equalsIgnoreCase(string)) {
            return SHA1WITHRSA_NORMALIZED_ALGO_NAME;
        }
        if (SHA256WITHRSA_NORMALIZED_ALGO_NAME.equalsIgnoreCase(string) || "SHA-256withRSA".equalsIgnoreCase(string) || "SHA-256withRSAEncryption".equalsIgnoreCase(string) || "SHA256withRSAEncryption".equalsIgnoreCase(string)) {
            return SHA256WITHRSA_NORMALIZED_ALGO_NAME;
        }
        if (SHA384WITHRSA_NORMALIZED_ALGO_NAME.equalsIgnoreCase(string) || "SHA-384withRSA".equalsIgnoreCase(string) || "SHA-384withRSAEncryption".equalsIgnoreCase(string) || "SHA384withRSAEncryption".equalsIgnoreCase(string)) {
            return SHA384WITHRSA_NORMALIZED_ALGO_NAME;
        }
        if (SHA512WITHRSA_NORMALIZED_ALGO_NAME.equalsIgnoreCase(string) || "SHA-512withRSA".equalsIgnoreCase(string) || "SHA-512withRSAEncryption".equalsIgnoreCase(string) || "SHA512withRSAEncryption".equalsIgnoreCase(string)) {
            return SHA512WITHRSA_NORMALIZED_ALGO_NAME;
        }
        return string;
    }

    private static byte[] selectHeaderTemplate(String string) {
        if (SHA1_NORMALIZED_ALGO_NAME.equals(string)) {
            return DigestInfo.getSha1DigestinfoHeader();
        }
        if (SHA256_NORMALIZED_ALGO_NAME.equals(string)) {
            return DigestInfo.getSha256DigestinfoHeader();
        }
        if (SHA384_NORMALIZED_ALGO_NAME.equals(string)) {
            return DigestInfo.getSha384DigestinfoHeader();
        }
        if (SHA512_NORMALIZED_ALGO_NAME.equals(string)) {
            return DigestInfo.getSha512DigestinfoHeader();
        }
        return new byte[0];
    }

    private static String getDigestAlgorithm(String string) {
        if (SHA1WITHRSA_NORMALIZED_ALGO_NAME.equals(string)) {
            return SHA1_NORMALIZED_ALGO_NAME;
        }
        if (SHA256WITHRSA_NORMALIZED_ALGO_NAME.equals(string)) {
            return SHA256_NORMALIZED_ALGO_NAME;
        }
        if (SHA384WITHRSA_NORMALIZED_ALGO_NAME.equals(string)) {
            return SHA384_NORMALIZED_ALGO_NAME;
        }
        if (SHA512WITHRSA_NORMALIZED_ALGO_NAME.equals(string)) {
            return SHA512_NORMALIZED_ALGO_NAME;
        }
        return string;
    }
}

