/*
 * Decompiled with CFR 0.152.
 */
package es.gob.jmulticard.asn1.der;

import es.gob.jmulticard.HexUtils;
import es.gob.jmulticard.asn1.Asn1Exception;
import es.gob.jmulticard.asn1.DecoderObject;
import es.gob.jmulticard.asn1.Tlv;
import es.gob.jmulticard.asn1.TlvException;
import java.io.UnsupportedEncodingException;

public final class Utf8String
extends DecoderObject {
    private static final byte TAG_UTF8STRING = 12;
    private static final byte TAG_PRINTABLESTRING = 19;
    private String stringValue = null;

    @Override
    protected byte getDefaultTag() {
        return 12;
    }

    @Override
    public void checkTag(byte by) throws Asn1Exception {
        if (12 != by && 19 != by) {
            throw new Asn1Exception("Se esperaba un tipo " + HexUtils.hexify(new byte[]{19}, false) + " o " + HexUtils.hexify(new byte[]{19}, false) + " (" + this.getClass().getName() + ") pero se encontro un tipo " + HexUtils.hexify(new byte[]{by}, false));
        }
    }

    @Override
    protected void decodeValue() throws Asn1Exception, TlvException {
        Tlv tlv = new Tlv(this.getRawDerValue());
        this.checkTag(tlv.getTag());
        try {
            this.stringValue = new String(tlv.getValue(), "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new Asn1Exception("No se soporta la codificacion UFT8 en el entorno de ejecucion: " + unsupportedEncodingException, unsupportedEncodingException);
        }
    }

    public String toString() {
        return this.stringValue;
    }
}

