/*
 * Decompiled with CFR 0.152.
 */
package es.gob.jmulticard.asn1.der;

import es.gob.jmulticard.asn1.Asn1Exception;
import es.gob.jmulticard.asn1.DecoderObject;
import es.gob.jmulticard.asn1.Tlv;
import es.gob.jmulticard.asn1.TlvException;
import java.util.Vector;

public abstract class SequenceOf
extends DecoderObject {
    private static final byte TAG_SEQUENCE = 48;
    private final Class<? extends DecoderObject> elementsType;
    private Vector<DecoderObject> sequenceObjects = null;

    @Override
    protected void decodeValue() throws Asn1Exception, TlvException {
        Tlv tlv = new Tlv(this.getRawDerValue());
        this.checkTag(tlv.getTag());
        byte[] byArray = tlv.getValue();
        this.sequenceObjects = new Vector();
        for (int i = 0; i < byArray.length; i += tlv.getBytes().length) {
            DecoderObject decoderObject;
            byte[] byArray2 = new byte[byArray.length - i];
            System.arraycopy(byArray, i, byArray2, 0, byArray2.length);
            tlv = new Tlv(byArray2);
            try {
                decoderObject = this.elementsType.newInstance();
            }
            catch (Exception exception) {
                throw new Asn1Exception("No se ha podido instanciar un " + this.elementsType.getName() + " en la secuencia: " + exception, exception);
            }
            decoderObject.checkTag(tlv.getTag());
            decoderObject.setDerValue(tlv.getBytes());
            this.sequenceObjects.add(decoderObject);
        }
    }

    protected SequenceOf(Class<? extends DecoderObject> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException();
        }
        this.elementsType = clazz;
    }

    @Override
    protected byte getDefaultTag() {
        return 48;
    }

    protected DecoderObject getElementAt(int n) {
        return this.sequenceObjects.elementAt(n);
    }

    protected int getElementCount() {
        return this.sequenceObjects.size();
    }
}

