/*
 * Decompiled with CFR 0.152.
 */
package es.gob.jmulticard.asn1.der;

import es.gob.jmulticard.asn1.Asn1Exception;
import es.gob.jmulticard.asn1.DecoderObject;
import es.gob.jmulticard.asn1.OptionalDecoderObjectElement;
import es.gob.jmulticard.asn1.Tlv;
import es.gob.jmulticard.asn1.TlvException;
import java.util.ArrayList;
import java.util.List;

public abstract class Sequence
extends DecoderObject {
    private static final byte TAG_SEQUENCE = 48;
    private final List<DecoderObject> elements = new ArrayList<DecoderObject>();
    private final OptionalDecoderObjectElement[] elementsTypes;

    protected int getElementCount() {
        return this.elements.size();
    }

    protected Sequence(OptionalDecoderObjectElement[] optionalDecoderObjectElementArray) {
        if (optionalDecoderObjectElementArray == null) {
            throw new IllegalArgumentException();
        }
        this.elementsTypes = new OptionalDecoderObjectElement[optionalDecoderObjectElementArray.length];
        System.arraycopy(optionalDecoderObjectElementArray, 0, this.elementsTypes, 0, optionalDecoderObjectElementArray.length);
    }

    @Override
    protected void decodeValue() throws Asn1Exception, TlvException {
        Tlv tlv = new Tlv(this.getRawDerValue());
        this.checkTag(tlv.getTag());
        int n = 0;
        byte[] byArray = tlv.getValue();
        for (int i = 0; i < this.elementsTypes.length; ++i) {
            DecoderObject decoderObject;
            Tlv tlv2;
            byte[] byArray2 = new byte[byArray.length - n];
            System.arraycopy(byArray, n, byArray2, 0, byArray2.length);
            try {
                tlv2 = new Tlv(byArray2);
                decoderObject = this.elementsTypes[i].getElementType().newInstance();
                decoderObject.checkTag(tlv2.getTag());
                decoderObject.setDerValue(tlv2.getBytes());
            }
            catch (Exception exception) {
                if (this.elementsTypes[i].isOptional()) continue;
                throw new Asn1Exception("Error en el elemento " + i + " de la recuencia ASN.1: " + exception, exception);
            }
            n += tlv2.getBytes().length;
            this.elements.add(decoderObject);
        }
    }

    @Override
    protected byte getDefaultTag() {
        return 48;
    }

    protected DecoderObject getElementAt(int n) {
        return this.elements.get(n);
    }
}

