/*
 * Decompiled with CFR 0.152.
 */
package es.gob.jmulticard.asn1.der;

import es.gob.jmulticard.asn1.Asn1Exception;
import es.gob.jmulticard.asn1.DecoderObject;
import es.gob.jmulticard.asn1.OptionalDecoderObjectElement;
import es.gob.jmulticard.asn1.Tlv;
import es.gob.jmulticard.asn1.TlvException;
import java.util.ArrayList;
import java.util.List;

public abstract class Record
extends DecoderObject {
    private final OptionalDecoderObjectElement[] elementsTypes;
    private final List<DecoderObject> elements = new ArrayList<DecoderObject>();

    protected Record(OptionalDecoderObjectElement[] optionalDecoderObjectElementArray) {
        if (optionalDecoderObjectElementArray == null || optionalDecoderObjectElementArray.length == 0) {
            throw new IllegalArgumentException("Los tipos de los elementos del registro no pueden ser nulos ni vacios");
        }
        this.elementsTypes = new OptionalDecoderObjectElement[optionalDecoderObjectElementArray.length];
        System.arraycopy(optionalDecoderObjectElementArray, 0, this.elementsTypes, 0, optionalDecoderObjectElementArray.length);
    }

    protected int getElementCount() {
        return this.elements.size();
    }

    protected DecoderObject getElementAt(int n) {
        if (n < 0 || n >= this.elements.size()) {
            throw new IndexOutOfBoundsException("No existe un elemento en este registro en el indice " + Integer.toString(n));
        }
        return this.elements.get(n);
    }

    @Override
    protected void decodeValue() throws Asn1Exception, TlvException {
        if (this.getRawDerValue().length == 0) {
            throw new Asn1Exception("El valor del objeto ASN.1 esta vacio");
        }
        int n = 0;
        for (int i = 0; i < this.elementsTypes.length; ++i) {
            DecoderObject decoderObject;
            Tlv tlv;
            try {
                byte[] byArray = new byte[this.getRawDerValue().length - n];
                System.arraycopy(this.getRawDerValue(), n, byArray, 0, byArray.length);
                tlv = new Tlv(byArray);
                try {
                    decoderObject = this.elementsTypes[i].getElementType().newInstance();
                }
                catch (Exception exception) {
                    throw new Asn1Exception("No se ha podido instanciar un " + this.elementsTypes[i].getElementType().getName() + " en la posicion " + Integer.toString(i) + " del registro: " + exception, exception);
                }
                decoderObject.checkTag(tlv.getTag());
            }
            catch (Exception exception) {
                if (this.elementsTypes[i].isOptional()) continue;
                throw new Asn1Exception("Error en el elemento " + i + " del registro ASN.1: " + exception, exception);
            }
            n += tlv.getBytes().length;
            decoderObject.setDerValue(tlv.getBytes());
            this.elements.add(decoderObject);
        }
    }

    @Override
    protected byte getDefaultTag() {
        throw new UnsupportedOperationException("No hay tipo por defecto");
    }
}

