/*
 * Decompiled with CFR 0.152.
 */
package es.gob.jmulticard.asn1.der;

import es.gob.jmulticard.HexUtils;
import es.gob.jmulticard.asn1.Asn1Exception;
import es.gob.jmulticard.asn1.DecoderObject;
import es.gob.jmulticard.asn1.Tlv;
import es.gob.jmulticard.asn1.TlvException;

public abstract class ContextSpecific
extends DecoderObject {
    private DecoderObject object = null;
    private final Class<? extends DecoderObject> elementType;

    protected DecoderObject getObject() {
        if (this.object == null) {
            throw new IllegalStateException();
        }
        return this.object;
    }

    @Override
    protected void decodeValue() throws Asn1Exception, TlvException {
        DecoderObject decoderObject;
        Tlv tlv = new Tlv(this.getRawDerValue());
        try {
            decoderObject = this.elementType.newInstance();
        }
        catch (Exception exception) {
            throw new Asn1Exception("No se ha podido instanciar un " + this.elementType.getName() + " en el contexto especifico: " + exception, exception);
        }
        decoderObject.setDerValue(tlv.getValue());
        this.object = decoderObject;
    }

    public ContextSpecific(Class<? extends DecoderObject> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("El tipo contenido dentro de ContextSpecific no puede ser nulo");
        }
        this.elementType = clazz;
    }

    @Override
    protected byte getDefaultTag() {
        throw new UnsupportedOperationException("No hay tipo por defecto");
    }

    @Override
    public void checkTag(byte by) throws Asn1Exception {
        if ((by & 0xC0) != 128) {
            throw new Asn1Exception("La etiqueta " + HexUtils.hexify(new byte[]{by}, false) + " no es valida para un objeto especifico del contexto");
        }
    }
}

