/*
 * Decompiled with CFR 0.152.
 */
package es.gob.jmulticard.asn1.bertlv;

import es.gob.jmulticard.asn1.bertlv.BitManipulationHelper;
import java.io.ByteArrayInputStream;
import java.math.BigInteger;

public final class BerTlvIdentifier {
    private byte[] value;

    public int getTagValue() {
        if (this.value == null) {
            return 0;
        }
        if (this.value.length == 1) {
            return this.value[0];
        }
        byte[] byArray = new byte[this.value.length - 1];
        System.arraycopy(this.value, 1, byArray, 0, this.value.length - 1);
        for (int i = 0; i < byArray.length - 1; ++i) {
            byArray[i] = (byte)BitManipulationHelper.setBitValue(byArray[i], 8, false);
        }
        return new BigInteger(byArray).intValue();
    }

    void decode(ByteArrayInputStream byteArrayInputStream) {
        block2: {
            boolean bl;
            int n = byteArrayInputStream.read();
            this.value = new byte[]{(byte)n};
            if ((n & 0x1F) != 31) break block2;
            do {
                int n2 = byteArrayInputStream.read();
                bl = false;
                if (!BitManipulationHelper.getBitValue(n2, 8)) {
                    bl = true;
                }
                this.value = BitManipulationHelper.mergeArrays(this.value, new byte[]{(byte)n2});
            } while (!bl);
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof BerTlvIdentifier) {
            BerTlvIdentifier berTlvIdentifier = (BerTlvIdentifier)object;
            if (this.value.length != berTlvIdentifier.value.length) {
                return false;
            }
            for (int i = 0; i < this.value.length; ++i) {
                try {
                    if (this.value[i] == berTlvIdentifier.value[i]) continue;
                    return false;
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        return new BigInteger(this.value).intValue();
    }

    public String toString() {
        if (this.value == null) {
            return "NULL";
        }
        StringBuffer stringBuffer = new StringBuffer("[");
        for (int i = 0; i < this.value.length; ++i) {
            stringBuffer.append("0x").append(Integer.toHexString(this.value[i])).append(' ');
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }
}

