/*
 * Decompiled with CFR 0.152.
 */
package es.gob.jmulticard.asn1.bertlv;

import es.gob.jmulticard.asn1.bertlv.BerTlvIdentifier;
import java.io.ByteArrayInputStream;

public final class BerTlv {
    private BerTlvIdentifier tag;
    private int length;
    private byte[] value;

    public BerTlvIdentifier getTag() {
        return this.tag;
    }

    public byte[] getValue() {
        if (this.value == null) {
            return null;
        }
        byte[] byArray = new byte[this.value.length];
        System.arraycopy(this.value, 0, byArray, 0, this.value.length);
        return byArray;
    }

    public static BerTlv getInstance(ByteArrayInputStream byteArrayInputStream) {
        BerTlv berTlv = new BerTlv();
        berTlv.decode(byteArrayInputStream);
        return berTlv;
    }

    private void decode(ByteArrayInputStream byteArrayInputStream) throws IndexOutOfBoundsException {
        int n;
        int n2;
        int n3;
        this.tag = new BerTlvIdentifier();
        this.tag.decode(byteArrayInputStream);
        int n4 = byteArrayInputStream.read();
        if (n4 <= 127) {
            this.length = n4;
        } else if (n4 == 128) {
            this.length = n4;
        } else {
            n3 = n4 & 0x7F;
            n4 = 0;
            for (n2 = 0; n2 < n3; ++n2) {
                n = byteArrayInputStream.read();
                n4 <<= 8;
                n4 |= n;
            }
            this.length = n4;
        }
        if (this.length == 128) {
            byteArrayInputStream.mark(0);
            n3 = 1;
            n2 = 0;
            n = 0;
            while (true) {
                ++n;
                n2 = byteArrayInputStream.read();
                if (n3 == 0 && n2 == 0) break;
                n3 = n2;
            }
            this.value = new byte[n -= 2];
            byteArrayInputStream.reset();
            if (n != byteArrayInputStream.read(this.value, 0, n)) {
                throw new IndexOutOfBoundsException("La longitud de los datos leidos no coincide con el parametro indicado");
            }
            this.length = n;
        } else {
            this.value = new byte[this.length];
            if (this.length != byteArrayInputStream.read(this.value, 0, this.length)) {
                throw new IndexOutOfBoundsException("La longitud de los datos leidos no coincide con el parametro indicado");
            }
        }
    }

    public String toString() {
        return "[TLV: T=" + this.tag + ";L=" + this.length + ";V=" + (this.value == null ? "null" : this.value.length + " bytes") + "]";
    }
}

