/*
 * Decompiled with CFR 0.152.
 */
package es.gob.jmulticard.asn1;

import es.gob.jmulticard.HexUtils;
import es.gob.jmulticard.asn1.TlvException;
import java.io.ByteArrayInputStream;
import java.io.IOException;

public final class Tlv {
    private final byte tag;
    private final int length;
    private final byte[] bytes;
    private final int valueOffset;

    public Tlv(byte by, byte[] byArray) {
        if (byArray == null) {
            throw new IllegalArgumentException("El valor del TLV no puede ser nulo");
        }
        this.valueOffset = 2;
        this.tag = by;
        this.length = byArray.length;
        this.bytes = new byte[byArray.length + 2];
        this.bytes[0] = by;
        this.bytes[1] = (byte)byArray.length;
        System.arraycopy(byArray, 0, this.bytes, 2, byArray.length);
    }

    public Tlv(byte[] byArray) throws TlvException {
        int n;
        boolean bl;
        if (byArray == null || byArray.length == 0) {
            throw new IllegalArgumentException("El TLV no puede ser nulo ni vacio");
        }
        if (byArray.length < 2) {
            throw new IllegalArgumentException("El TLV no puede medir menos de dos octetos: " + HexUtils.hexify(byArray, false));
        }
        int n2 = 0;
        byte[] byArray2 = new byte[byArray.length];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        this.tag = byArray2[n2++];
        if ((this.tag & 0x1F) == 31) {
            throw new TlvException("El tipo del TLV es invalido");
        }
        boolean bl2 = bl = (n = byArray2[n2++] & 0xFF) == 128;
        if (bl) {
            if ((this.tag & 0x20) == 0) {
                throw new TlvException("Longitud del TLV invalida");
            }
        } else if (n >= 128) {
            int n3 = n - 128;
            if (n3 > 3) {
                throw new TlvException("TLV demasiado largo");
            }
            n = 0;
            while (n3 > 0) {
                n = (n << 8) + (byArray2[n2++] & 0xFF);
                --n3;
            }
        }
        this.length = n;
        this.valueOffset = n2;
        this.bytes = new byte[this.valueOffset + this.length];
        System.arraycopy(byArray2, 0, this.bytes, 0, this.valueOffset + this.length);
    }

    public byte[] getBytes() {
        byte[] byArray = new byte[this.bytes.length];
        System.arraycopy(this.bytes, 0, byArray, 0, this.bytes.length);
        return byArray;
    }

    public int getLength() {
        return this.length;
    }

    public byte getTag() {
        return this.tag;
    }

    public byte[] getValue() {
        byte[] byArray = new byte[this.length];
        System.arraycopy(this.bytes, this.valueOffset, byArray, 0, this.length);
        return byArray;
    }

    public static Tlv decode(ByteArrayInputStream byteArrayInputStream) throws IOException {
        byte[] byArray;
        boolean bl;
        byte by = (byte)byteArrayInputStream.read();
        if ((by & 0x1F) == 31) {
            throw new IOException("El tipo del TLV es invalido");
        }
        int n = byteArrayInputStream.read() & 0xFF;
        boolean bl2 = bl = n == 128;
        if (bl) {
            if ((by & 0x20) == 0) {
                throw new IOException("Longitud del TLV invalida");
            }
        } else if (n >= 128) {
            int n2 = n - 128;
            if (n2 > 3) {
                throw new IOException("TLV demasiado largo");
            }
            n = 0;
            while (n2 > 0) {
                n = (n << 8) + (byteArrayInputStream.read() & 0xFF);
                --n2;
            }
        }
        if ((byArray = new byte[n]).length != byteArrayInputStream.read(byArray)) {
            throw new IndexOutOfBoundsException("La longitud de los datos leidos no coincide con el parametro indicado");
        }
        return new Tlv(by, byArray);
    }
}

