/*
 * Decompiled with CFR 0.152.
 */
package es.gob.jmulticard.asn1;

import es.gob.jmulticard.HexUtils;
import es.gob.jmulticard.asn1.Asn1Exception;
import es.gob.jmulticard.asn1.TlvException;

public abstract class DecoderObject {
    private byte[] rawDerValue = null;

    protected byte[] getRawDerValue() {
        byte[] byArray = new byte[this.rawDerValue.length];
        System.arraycopy(this.rawDerValue, 0, byArray, 0, this.rawDerValue.length);
        return byArray;
    }

    public void setDerValue(byte[] byArray) throws Asn1Exception, TlvException {
        if (byArray == null) {
            throw new IllegalArgumentException("El valor del objeto ASN.1 no puede ser nulo");
        }
        this.rawDerValue = new byte[byArray.length];
        System.arraycopy(byArray, 0, this.rawDerValue, 0, byArray.length);
        this.decodeValue();
    }

    public byte[] getBytes() {
        byte[] byArray = new byte[this.rawDerValue.length];
        System.arraycopy(this.rawDerValue, 0, byArray, 0, this.rawDerValue.length);
        return byArray;
    }

    protected abstract void decodeValue() throws Asn1Exception, TlvException;

    protected abstract byte getDefaultTag();

    public void checkTag(byte by) throws Asn1Exception {
        if (this.getDefaultTag() != by) {
            throw new Asn1Exception("Se esperaba un tipo " + HexUtils.hexify(new byte[]{this.getDefaultTag()}, false) + " (" + this.getClass().getName() + ") pero se encontro un tipo " + HexUtils.hexify(new byte[]{by}, false));
        }
    }
}

