/*
 * Decompiled with CFR 0.152.
 */
package es.gob.jmulticard.apdu.iso7816four;

import es.gob.jmulticard.apdu.Apdu;
import es.gob.jmulticard.apdu.ResponseApdu;

public final class SelectFileApduResponse
extends ResponseApdu {
    private byte[] dfName = null;
    private byte[] fileId = null;
    private byte[] fileLength = null;

    public SelectFileApduResponse(Apdu apdu) {
        super(apdu.getBytes());
        this.decode();
    }

    private void decode() {
        if (this.isOk()) {
            byte by = this.getData()[1];
            if (this.getData().length - 2 == by) {
                byte by2;
                int n = 2;
                if (this.getData()[n] == -127) {
                    by2 = this.getData()[++n];
                    this.fileLength = this.getBytesFromData(++n, by2);
                    n += by2;
                }
                if (this.getData()[n] == -127) {
                    by2 = this.getData()[++n];
                    this.fileId = this.getBytesFromData(++n, by2);
                    n += by2;
                }
                if (this.getData()[n] == -124) {
                    by2 = this.getData()[++n];
                    this.dfName = this.getBytesFromData(++n, by2);
                    n += by2;
                }
                if (this.getData()[n] == -123 && this.getData()[n + 1] == 10) {
                    this.fileId = this.getBytesFromData(n + 3, 2);
                    this.fileLength = this.getBytesFromData(n + 5, 2);
                }
            }
        }
    }

    private byte[] getBytesFromData(int n, int n2) {
        byte[] byArray = new byte[n2];
        System.arraycopy(this.getData(), n, byArray, 0, n2);
        return byArray;
    }

    byte[] getDfName() {
        byte[] byArray = new byte[this.dfName.length];
        System.arraycopy(this.dfName, 0, byArray, 0, this.dfName.length);
        return byArray;
    }

    byte[] getFileId() {
        byte[] byArray = new byte[this.fileId.length];
        System.arraycopy(this.fileId, 0, byArray, 0, this.fileId.length);
        return byArray;
    }

    public int getFileLength() {
        if (this.fileLength != null) {
            return (this.fileLength[0] & 0xFF) << 8 | this.fileLength[1] & 0xFF;
        }
        return 0;
    }

    @Override
    public boolean isOk() {
        return super.isOk() && this.getData()[0] == 111 && this.getData().length > 2;
    }
}

